/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.io.InputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.codec.language.bm.Languages$1;
import org.apache.commons.codec.language.bm.Languages$2;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;

public class Languages {
    public static final String ANY = "any";
    private static final Map<NameType, Languages> LANGUAGES = new EnumMap<NameType, Languages>(NameType.class);
    private final Set<String> languages;
    public static final Languages$LanguageSet NO_LANGUAGES;
    public static final Languages$LanguageSet ANY_LANGUAGE;

    public static Languages getInstance(NameType nameType) {
        return LANGUAGES.get((Object)nameType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Languages getInstance(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        InputStream inputStream = Languages.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to resolve required resource: " + string);
        }
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        try {
            boolean bl2 = false;
            while (scanner.hasNextLine()) {
                String string2 = scanner.nextLine().trim();
                if (bl2) {
                    if (!string2.endsWith("*/")) continue;
                    bl2 = false;
                    continue;
                }
                if (string2.startsWith("/*")) {
                    bl2 = true;
                    continue;
                }
                if (string2.length() <= 0) continue;
                hashSet.add(string2);
            }
        }
        finally {
            scanner.close();
        }
        return new Languages(Collections.unmodifiableSet(hashSet));
    }

    private static String langResourceName(NameType nameType) {
        return String.format("org/apache/commons/codec/language/bm/%s_languages.txt", nameType.getName());
    }

    private Languages(Set<String> set) {
        this.languages = set;
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    static {
        for (NameType nameType : NameType.values()) {
            LANGUAGES.put(nameType, Languages.getInstance(Languages.langResourceName(nameType)));
        }
        NO_LANGUAGES = new Languages$1();
        ANY_LANGUAGE = new Languages$2();
    }
}

