/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.DaitchMokotoffSoundex$1;
import org.apache.commons.codec.language.DaitchMokotoffSoundex$Branch;
import org.apache.commons.codec.language.DaitchMokotoffSoundex$Rule;

public class DaitchMokotoffSoundex
implements StringEncoder {
    private static final String COMMENT = "//";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String MULTILINE_COMMENT_END = "*/";
    private static final String MULTILINE_COMMENT_START = "/*";
    private static final String RESOURCE_FILE = "org/apache/commons/codec/language/dmrules.txt";
    private static final int MAX_LENGTH = 6;
    private static final Map<Character, List<DaitchMokotoffSoundex$Rule>> RULES = new HashMap<Character, List<DaitchMokotoffSoundex$Rule>>();
    private static final Map<Character, Character> FOLDINGS = new HashMap<Character, Character>();
    private final boolean folding;

    private static void parseRules(Scanner scanner, String string, Map<Character, List<DaitchMokotoffSoundex$Rule>> map, Map<Character, Character> map2) {
        int n2 = 0;
        boolean bl2 = false;
        while (scanner.hasNextLine()) {
            String string2;
            String string3;
            String[] stringArray;
            String string4;
            ++n2;
            String string5 = string4 = scanner.nextLine();
            if (bl2) {
                if (!string5.endsWith(MULTILINE_COMMENT_END)) continue;
                bl2 = false;
                continue;
            }
            if (string5.startsWith(MULTILINE_COMMENT_START)) {
                bl2 = true;
                continue;
            }
            int n3 = string5.indexOf(COMMENT);
            if (n3 >= 0) {
                string5 = string5.substring(0, n3);
            }
            if ((string5 = string5.trim()).length() == 0) continue;
            if (string5.contains("=")) {
                stringArray = string5.split("=");
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException("Malformed folding statement split into " + stringArray.length + " parts: " + string4 + " in " + string);
                }
                string3 = stringArray[0];
                string2 = stringArray[1];
                if (string3.length() != 1 || string2.length() != 1) {
                    throw new IllegalArgumentException("Malformed folding statement - patterns are not single characters: " + string4 + " in " + string);
                }
                map2.put(Character.valueOf(string3.charAt(0)), Character.valueOf(string2.charAt(0)));
                continue;
            }
            stringArray = string5.split("\\s+");
            if (stringArray.length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + stringArray.length + " parts: " + string4 + " in " + string);
            }
            try {
                string3 = DaitchMokotoffSoundex.stripQuotes(stringArray[0]);
                string2 = DaitchMokotoffSoundex.stripQuotes(stringArray[1]);
                String string6 = DaitchMokotoffSoundex.stripQuotes(stringArray[2]);
                String string7 = DaitchMokotoffSoundex.stripQuotes(stringArray[3]);
                DaitchMokotoffSoundex$Rule daitchMokotoffSoundex$Rule = new DaitchMokotoffSoundex$Rule(string3, string2, string6, string7);
                char c2 = DaitchMokotoffSoundex$Rule.access$000(daitchMokotoffSoundex$Rule).charAt(0);
                List<DaitchMokotoffSoundex$Rule> list = map.get(Character.valueOf(c2));
                if (list == null) {
                    list = new ArrayList<DaitchMokotoffSoundex$Rule>();
                    map.put(Character.valueOf(c2), list);
                }
                list.add(daitchMokotoffSoundex$Rule);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line '" + n2 + "' in " + string, illegalArgumentException);
            }
        }
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public DaitchMokotoffSoundex() {
        this(true);
    }

    public DaitchMokotoffSoundex(boolean bl2) {
        this.folding = bl2;
    }

    private String cleanup(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (Character.isWhitespace(c2)) continue;
            c2 = Character.toLowerCase(c2);
            if (this.folding && FOLDINGS.containsKey(Character.valueOf(c2))) {
                c2 = FOLDINGS.get(Character.valueOf(c2)).charValue();
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object encode(Object object) {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to DaitchMokotoffSoundex encode is not of type java.lang.String");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        if (string == null) {
            return null;
        }
        return this.soundex(string, false)[0];
    }

    public String soundex(String string) {
        String[] stringArray = this.soundex(string, true);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string2 : stringArray) {
            stringBuilder.append(string2);
            if (++n2 >= stringArray.length) continue;
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    private String[] soundex(String string, boolean bl2) {
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = this.cleanup(string);
        LinkedHashSet<DaitchMokotoffSoundex$Branch> linkedHashSet = new LinkedHashSet<DaitchMokotoffSoundex$Branch>();
        linkedHashSet.add(new DaitchMokotoffSoundex$Branch(null));
        int n3 = 0;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            n2 = string2.charAt(i2);
            if (Character.isWhitespace((char)n2)) continue;
            String string3 = string2.substring(i2);
            List<DaitchMokotoffSoundex$Rule> list = RULES.get(Character.valueOf((char)n2));
            if (list == null) continue;
            List list2 = bl2 ? new ArrayList() : Collections.EMPTY_LIST;
            for (DaitchMokotoffSoundex$Rule daitchMokotoffSoundex$Rule : list) {
                if (!daitchMokotoffSoundex$Rule.matches(string3)) continue;
                if (bl2) {
                    list2.clear();
                }
                String[] stringArray = daitchMokotoffSoundex$Rule.getReplacements(string3, n3 == 0);
                boolean bl3 = stringArray.length > 1 && bl2;
                block2: for (DaitchMokotoffSoundex$Branch daitchMokotoffSoundex$Branch : linkedHashSet) {
                    for (String string4 : stringArray) {
                        DaitchMokotoffSoundex$Branch daitchMokotoffSoundex$Branch2 = bl3 ? daitchMokotoffSoundex$Branch.createBranch() : daitchMokotoffSoundex$Branch;
                        boolean bl4 = n3 == 109 && n2 == 110 || n3 == 110 && n2 == 109;
                        daitchMokotoffSoundex$Branch2.processNextReplacement(string4, bl4);
                        if (!bl2) continue block2;
                        list2.add(daitchMokotoffSoundex$Branch2);
                    }
                }
                if (bl2) {
                    linkedHashSet.clear();
                    linkedHashSet.addAll(list2);
                }
                i2 += daitchMokotoffSoundex$Rule.getPatternLength() - 1;
                break;
            }
            n3 = n2;
        }
        String[] stringArray = new String[linkedHashSet.size()];
        n2 = 0;
        for (DaitchMokotoffSoundex$Branch daitchMokotoffSoundex$Branch : linkedHashSet) {
            daitchMokotoffSoundex$Branch.finish();
            stringArray[n2++] = daitchMokotoffSoundex$Branch.toString();
        }
        return stringArray;
    }

    static {
        InputStream inputStream = DaitchMokotoffSoundex.class.getClassLoader().getResourceAsStream(RESOURCE_FILE);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to load resource: org/apache/commons/codec/language/dmrules.txt");
        }
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        DaitchMokotoffSoundex.parseRules(scanner, RESOURCE_FILE, RULES, FOLDINGS);
        scanner.close();
        for (Map.Entry<Character, List<DaitchMokotoffSoundex$Rule>> entry : RULES.entrySet()) {
            List<DaitchMokotoffSoundex$Rule> list = entry.getValue();
            Collections.sort(list, new DaitchMokotoffSoundex$1());
        }
    }
}

