/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.BaseNCodec$Context;
import org.apache.commons.codec.binary.StringUtils;

public abstract class BaseNCodec
implements BinaryDecoder,
BinaryEncoder {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    @Deprecated
    protected final byte PAD = (byte)61;
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    protected BaseNCodec(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 61);
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5, byte by2) {
        this.unencodedBlockSize = n2;
        this.encodedBlockSize = n3;
        boolean bl2 = n4 > 0 && n5 > 0;
        this.lineLength = bl2 ? n4 / n3 * n3 : 0;
        this.chunkSeparatorLength = n5;
        this.pad = by2;
    }

    boolean hasData(BaseNCodec$Context baseNCodec$Context) {
        return baseNCodec$Context.buffer != null;
    }

    int available(BaseNCodec$Context baseNCodec$Context) {
        return baseNCodec$Context.buffer != null ? baseNCodec$Context.pos - baseNCodec$Context.readPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private byte[] resizeBuffer(BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.buffer == null) {
            baseNCodec$Context.buffer = new byte[this.getDefaultBufferSize()];
            baseNCodec$Context.pos = 0;
            baseNCodec$Context.readPos = 0;
        } else {
            byte[] byArray = new byte[baseNCodec$Context.buffer.length * 2];
            System.arraycopy(baseNCodec$Context.buffer, 0, byArray, 0, baseNCodec$Context.buffer.length);
            baseNCodec$Context.buffer = byArray;
        }
        return baseNCodec$Context.buffer;
    }

    protected byte[] ensureBufferSize(int n2, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.buffer == null || baseNCodec$Context.buffer.length < baseNCodec$Context.pos + n2) {
            return this.resizeBuffer(baseNCodec$Context);
        }
        return baseNCodec$Context.buffer;
    }

    int readResults(byte[] byArray, int n2, int n3, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.buffer != null) {
            int n4 = Math.min(this.available(baseNCodec$Context), n3);
            System.arraycopy(baseNCodec$Context.buffer, baseNCodec$Context.readPos, byArray, n2, n4);
            baseNCodec$Context.readPos += n4;
            if (baseNCodec$Context.readPos >= baseNCodec$Context.pos) {
                baseNCodec$Context.buffer = null;
            }
            return n4;
        }
        return baseNCodec$Context.eof ? -1 : 0;
    }

    protected static boolean isWhiteSpace(byte by2) {
        switch (by2) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object encode(Object object) {
        if (!(object instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public String encodeToString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    public String encodeAsString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    @Override
    public Object decode(Object object) {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    public byte[] decode(String string) {
        return this.decode(StringUtils.getBytesUtf8(string));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        BaseNCodec$Context baseNCodec$Context = new BaseNCodec$Context();
        this.decode(byArray, 0, byArray.length, baseNCodec$Context);
        this.decode(byArray, 0, -1, baseNCodec$Context);
        byte[] byArray2 = new byte[baseNCodec$Context.pos];
        this.readResults(byArray2, 0, byArray2.length, baseNCodec$Context);
        return byArray2;
    }

    @Override
    public byte[] encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        BaseNCodec$Context baseNCodec$Context = new BaseNCodec$Context();
        this.encode(byArray, 0, byArray.length, baseNCodec$Context);
        this.encode(byArray, 0, -1, baseNCodec$Context);
        byte[] byArray2 = new byte[baseNCodec$Context.pos - baseNCodec$Context.readPos];
        this.readResults(byArray2, 0, byArray2.length, baseNCodec$Context);
        return byArray2;
    }

    abstract void encode(byte[] var1, int var2, int var3, BaseNCodec$Context var4);

    abstract void decode(byte[] var1, int var2, int var3, BaseNCodec$Context var4);

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (this.isInAlphabet(byArray[i2]) || bl2 && (byArray[i2] == this.pad || BaseNCodec.isWhiteSpace(byArray[i2]))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(StringUtils.getBytesUtf8(string), true);
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (byte by2 : byArray) {
            if (this.pad != by2 && !this.isInAlphabet(by2)) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] byArray) {
        long l2 = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l2 += (l2 + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l2;
    }
}

