/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscGrowableAtomicArrayQueue<E>
extends MpscChunkedAtomicArrayQueue<E> {
    public MpscGrowableAtomicArrayQueue(int n2) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(n2 / 8)), n2);
    }

    public MpscGrowableAtomicArrayQueue(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> atomicReferenceArray) {
        long l2 = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(LinkedAtomicArrayQueueUtil.length(atomicReferenceArray), l2, "buffer.length");
        int n2 = 2 * (LinkedAtomicArrayQueueUtil.length(atomicReferenceArray) - 1);
        return n2 + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long l2) {
        return l2 + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : l2;
    }
}

