/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();

    public BaseMpscLinkedAtomicArrayQueue(int n2) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n2, 2, "initialCapacity");
        int n3 = Pow2.roundToPowerOfTwo(n2);
        long l2 = n3 - 1 << 1;
        this.producerBuffer = atomicReferenceArray = LinkedAtomicArrayQueueUtil.allocate(n3 + 1);
        this.producerMask = l2;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l2;
        this.soProducerLimit(l2);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        long l5 = l2 - l4 >> 1;
        if (l5 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l5;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e2) {
        AtomicReferenceArray atomicReferenceArray;
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            if (l4 <= l3) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, atomicReferenceArray, l3, e2);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l3, l3 + 2L)) break;
        }
        int n3 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l3, l2);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n3, e2);
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        int n2 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        if (e2 == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e2 == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.getNextBuffer(atomicReferenceArray, l3);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    @Override
    public E peek() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        int n2 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        if (e2 == null && l2 != this.lvProducerIndex()) {
            while ((e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2)) == null) {
            }
        }
        if (e2 == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(atomicReferenceArray, l3), l2);
        }
        return e2;
    }

    private int offerSlowPath(long l2, long l3, long l4) {
        long l5 = this.lvConsumerIndex();
        long l6 = this.getCurrentBufferCapacity(l2);
        int n2 = 0;
        if (l5 + l6 > l3) {
            if (!this.casProducerLimit(l4, l5 + l6)) {
                n2 = 1;
            }
        } else {
            n2 = this.availableInQueue(l3, l5) <= 0L ? 2 : (this.casProducerIndex(l3, l3 + 1L) ? 3 : 1);
        }
        return n2;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> getNextBuffer(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n2 = this.nextArrayOffset(l2);
        AtomicReferenceArray atomicReferenceArray2 = (AtomicReferenceArray)LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n2, null);
        return atomicReferenceArray2;
    }

    private int nextArrayOffset(long l2) {
        return LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n2 = this.newBufferAndOffset(atomicReferenceArray, l2);
        E e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        if (e2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    private E newBufferPeek(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n2 = this.newBufferAndOffset(atomicReferenceArray, l2);
        E e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        if (null == e2) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e2;
    }

    private int newBufferAndOffset(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = LinkedAtomicArrayQueueUtil.length(atomicReferenceArray) - 2 << 1;
        int n2 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, this.consumerMask);
        return n2;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        int n2 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        if (e2 == null) {
            return null;
        }
        if (e2 == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.getNextBuffer(atomicReferenceArray, l3);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        int n2 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n2);
        if (e2 == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(atomicReferenceArray, l3), l2);
        }
        return e2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n2;
        long l2 = 0L;
        int n3 = this.capacity();
        do {
            if ((n2 = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n2) <= (long)n3);
        return (int)l2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n2) {
        long l2;
        AtomicReferenceArray atomicReferenceArray;
        long l3;
        long l4;
        block5: while (true) {
            long l5 = this.lvProducerLimit();
            l4 = this.lvProducerIndex();
            if ((l4 & 1L) == 1L) continue;
            l3 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            l2 = Math.min(l5, l4 + (long)(2 * n2));
            if (l4 == l5 || l5 < l2) {
                int n3 = this.offerSlowPath(l3, l4, l5);
                switch (n3) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l3, atomicReferenceArray, l4, messagePassingQueue$Supplier.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l4, l2)) break;
        }
        int n4 = (int)((l2 - l4) / 2L);
        int n5 = 0;
        for (n5 = 0; n5 < n4; ++n5) {
            int n6 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l4 + (long)(2 * n5), l3);
            LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n6, messagePassingQueue$Supplier.get());
        }
        return n4;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            while (this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0 && messagePassingQueue$ExitCondition.keepRunning()) {
            }
            int n2 = 0;
            while (messagePassingQueue$ExitCondition.keepRunning() && this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
            }
        }
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n2) {
        E e2;
        int n3;
        for (n3 = 0; n3 < n2 && (e2 = this.relaxedPoll()) != null; ++n3) {
            messagePassingQueue$Consumer.accept(e2);
        }
        return n3;
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        int n2 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            E e2 = this.relaxedPoll();
            if (e2 == null) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
                continue;
            }
            n2 = 0;
            messagePassingQueue$Consumer.accept(e2);
        }
    }

    private void resize(long l2, AtomicReferenceArray<E> atomicReferenceArray, long l3, E e2) {
        AtomicReferenceArray atomicReferenceArray2;
        int n2 = this.getNextBufferSize(atomicReferenceArray);
        this.producerBuffer = atomicReferenceArray2 = LinkedAtomicArrayQueueUtil.allocate(n2);
        int n3 = n2 - 2 << 1;
        this.producerMask = n3;
        int n4 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l3, l2);
        int n5 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l3, n3);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray2, n5, e2);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, this.nextArrayOffset(l2), atomicReferenceArray2);
        long l4 = this.lvConsumerIndex();
        long l5 = this.availableInQueue(l3, l4);
        RangeUtil.checkPositive(l5, "availableInQueue");
        this.soProducerLimit(l3 + Math.min((long)n3, l5));
        this.soProducerIndex(l3 + 2L);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n4, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

