/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil$IndexedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;

abstract class AtomicReferenceArrayQueue<E>
extends AbstractQueue<E>
implements IndexedQueueSizeUtil$IndexedQueue,
MessagePassingQueue<E>,
QueueProgressIndicators {
    protected final AtomicReferenceArray<E> buffer;
    protected final int mask;

    public AtomicReferenceArrayQueue(int n2) {
        int n3 = Pow2.roundToPowerOfTwo(n2);
        this.mask = n3 - 1;
        this.buffer = new AtomicReferenceArray(n3);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    protected final int calcElementOffset(long l2, int n2) {
        return (int)l2 & n2;
    }

    protected final int calcElementOffset(long l2) {
        return (int)l2 & this.mask;
    }

    public static <E> E lvElement(AtomicReferenceArray<E> atomicReferenceArray, int n2) {
        return atomicReferenceArray.get(n2);
    }

    public static <E> E lpElement(AtomicReferenceArray<E> atomicReferenceArray, int n2) {
        return atomicReferenceArray.get(n2);
    }

    protected final E lpElement(int n2) {
        return this.buffer.get(n2);
    }

    public static <E> void spElement(AtomicReferenceArray<E> atomicReferenceArray, int n2, E e2) {
        atomicReferenceArray.lazySet(n2, e2);
    }

    protected final void spElement(int n2, E e2) {
        this.buffer.lazySet(n2, e2);
    }

    public static <E> void soElement(AtomicReferenceArray<E> atomicReferenceArray, int n2, E e2) {
        atomicReferenceArray.lazySet(n2, e2);
    }

    protected final void soElement(int n2, E e2) {
        this.buffer.lazySet(n2, e2);
    }

    public static <E> void svElement(AtomicReferenceArray<E> atomicReferenceArray, int n2, E e2) {
        atomicReferenceArray.set(n2, e2);
    }

    protected final E lvElement(int n2) {
        return AtomicReferenceArrayQueue.lvElement(this.buffer, n2);
    }

    @Override
    public final int capacity() {
        return this.mask + 1;
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public final long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public final long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

