/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpscArrayQueue<E>
extends MpscArrayQueueL3Pad<E> {
    public MpscArrayQueue(int n2) {
        super(n2);
    }

    public boolean offerIfBelowThreshold(E e2, int n2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long l6 = this.lvProducerLimit();
        do {
            long l7;
            if ((l7 = l5 - (l2 = l6 - (l3 = this.lvProducerIndex()))) < (long)n2) continue;
            long l8 = this.lvConsumerIndex();
            l7 = l3 - l8;
            if (l7 >= (long)n2) {
                return false;
            }
            l6 = l8 + l5;
            this.soProducerLimit(l6);
        } while (!this.casProducerIndex(l3, l3 + 1L));
        l2 = MpscArrayQueue.calcElementOffset(l3, l4);
        UnsafeRefArrayAccess.soElement(this.buffer, l2, e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = this.lvProducerLimit();
        do {
            if ((l3 = this.lvProducerIndex()) < l5) continue;
            l2 = this.lvConsumerIndex();
            l5 = l2 + l4 + 1L;
            if (l3 >= l5) {
                return false;
            }
            this.soProducerLimit(l5);
        } while (!this.casProducerIndex(l3, l3 + 1L));
        l2 = MpscArrayQueue.calcElementOffset(l3, l4);
        UnsafeRefArrayAccess.soElement(this.buffer, l2, e2);
        return true;
    }

    public final int failFastOffer(E e2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long l6 = this.lvProducerIndex();
        if (l6 >= (l3 = this.lvProducerLimit())) {
            l2 = this.lvConsumerIndex();
            l3 = l2 + l5;
            if (l6 >= l3) {
                return 1;
            }
            this.soProducerLimit(l3);
        }
        if (!this.casProducerIndex(l6, l6 + 1L)) {
            return -1;
        }
        l2 = MpscArrayQueue.calcElementOffset(l6, l4);
        UnsafeRefArrayAccess.soElement(this.buffer, l2, e2);
        return 0;
    }

    @Override
    public E poll() {
        Object[] objectArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        long l3 = this.calcElementOffset(l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (null == object) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 1L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        long l3 = this.calcElementOffset(l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (null == object) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        return (E)object;
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        Object[] objectArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        long l3 = this.calcElementOffset(l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (null == object) {
            return null;
        }
        UnsafeRefArrayAccess.spElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 1L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object[] objectArray = this.buffer;
        long l2 = this.mask;
        long l3 = this.lpConsumerIndex();
        return (E)UnsafeRefArrayAccess.lvElement(objectArray, MpscArrayQueue.calcElementOffset(l3, l2));
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n2;
        long l2 = 0L;
        int n3 = this.capacity();
        do {
            if ((n2 = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n2) <= (long)n3);
        return (int)l2;
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n2) {
        Object[] objectArray = this.buffer;
        long l2 = this.mask;
        long l3 = this.lpConsumerIndex();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l4 = l3 + (long)i2;
            long l5 = MpscArrayQueue.calcElementOffset(l4, l2);
            Object object = UnsafeRefArrayAccess.lvElement(objectArray, l5);
            if (null == object) {
                return i2;
            }
            UnsafeRefArrayAccess.spElement(objectArray, l5, null);
            this.soConsumerIndex(l4 + 1L);
            messagePassingQueue$Consumer.accept(object);
        }
        return n2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n2) {
        long l2;
        long l3;
        long l4;
        long l5 = this.mask;
        long l6 = l5 + 1L;
        long l7 = this.lvProducerLimit();
        int n3 = 0;
        do {
            if ((l3 = l7 - (l4 = this.lvProducerIndex())) > 0L) continue;
            l2 = this.lvConsumerIndex();
            l7 = l2 + l6;
            l3 = l7 - l4;
            if (l3 <= 0L) {
                return 0;
            }
            this.soProducerLimit(l7);
        } while (!this.casProducerIndex(l4, l4 + (long)(n3 = Math.min((int)l3, n2))));
        Object[] objectArray = this.buffer;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 = MpscArrayQueue.calcElementOffset(l4 + (long)i2, l5);
            UnsafeRefArrayAccess.soElement(objectArray, l2, messagePassingQueue$Supplier.get());
        }
        return n3;
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        Object[] objectArray = this.buffer;
        long l2 = this.mask;
        long l3 = this.lpConsumerIndex();
        int n2 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            for (int i2 = 0; i2 < 4096; ++i2) {
                long l4 = MpscArrayQueue.calcElementOffset(l3, l2);
                Object object = UnsafeRefArrayAccess.lvElement(objectArray, l4);
                if (null == object) {
                    n2 = messagePassingQueue$WaitStrategy.idle(n2);
                    continue;
                }
                n2 = 0;
                UnsafeRefArrayAccess.spElement(objectArray, l4, null);
                this.soConsumerIndex(++l3);
                messagePassingQueue$Consumer.accept(object);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        int n2 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            if (this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
                continue;
            }
            n2 = 0;
        }
    }
}

