/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;
import java.util.Iterator;

public abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedArrayQueue(int n2) {
        RangeUtil.checkGreaterThanOrEqual(n2, 2, "initialCapacity");
        int n3 = Pow2.roundToPowerOfTwo(n2);
        long l2 = n3 - 1 << 1;
        E[] EArray = CircularArrayOffsetCalculator.allocate(n3 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.soProducerLimit(l2);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        long l5 = l2 - l4 >> 1;
        if (l5 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l5;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e2) {
        Object[] objectArray;
        long l2;
        long l3;
        long l4;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            objectArray = this.producerBuffer;
            if (l4 <= l3) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, objectArray, l3, e2);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l3, l3 + 2L)) break;
        }
        l4 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l3, l2);
        UnsafeRefArrayAccess.soElement(objectArray, l4, e2);
        return true;
    }

    @Override
    public E poll() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l4);
        if (object == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l4)) == null) {
                }
            } else {
                return null;
            }
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l3);
            return (E)this.newBufferPoll(objectArray2, l2);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l4, null);
        this.soConsumerIndex(l2 + 2L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l4);
        if (object == null && l2 != this.lvProducerIndex()) {
            while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l4)) == null) {
            }
        }
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l3), l2);
        }
        return (E)object;
    }

    private int offerSlowPath(long l2, long l3, long l4) {
        long l5;
        long l6 = this.lvConsumerIndex();
        if (l6 + (l5 = this.getCurrentBufferCapacity(l2)) > l3) {
            if (!this.casProducerLimit(l4, l6 + l5)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l3, l6) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l3, l3 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private E[] getNextBuffer(E[] EArray, long l2) {
        long l3 = this.nextArrayOffset(l2);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvElement(EArray, l3);
        UnsafeRefArrayAccess.soElement(EArray, l3, null);
        return objectArray;
    }

    private long nextArrayOffset(long l2) {
        return LinkedArrayQueueUtil.modifiedCalcElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l2) {
        long l3 = this.newBufferAndOffset(EArray, l2);
        E e2 = UnsafeRefArrayAccess.lvElement(EArray, l3);
        if (e2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(EArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    private E newBufferPeek(E[] EArray, long l2) {
        long l3 = this.newBufferAndOffset(EArray, l2);
        E e2 = UnsafeRefArrayAccess.lvElement(EArray, l3);
        if (null == e2) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e2;
    }

    private long newBufferAndOffset(E[] EArray, long l2) {
        this.consumerBuffer = EArray;
        this.consumerMask = LinkedArrayQueueUtil.length(EArray) - 2 << 1;
        return LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, this.consumerMask);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l4);
        if (object == null) {
            return null;
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l3);
            return (E)this.newBufferPoll(objectArray2, l2);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l4, null);
        this.soConsumerIndex(l2 + 2L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l3);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l4);
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l3), l2);
        }
        return (E)object;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n2;
        long l2 = 0L;
        int n3 = this.capacity();
        do {
            if ((n2 = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n2) <= (long)n3);
        return (int)l2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n2) {
        long l2;
        Object[] objectArray;
        long l3;
        long l4;
        block5: while (true) {
            long l5 = this.lvProducerLimit();
            l4 = this.lvProducerIndex();
            if ((l4 & 1L) == 1L) continue;
            l3 = this.producerMask;
            objectArray = this.producerBuffer;
            l2 = Math.min(l5, l4 + (long)(2 * n2));
            if (l4 >= l5 || l5 < l2) {
                int n3 = this.offerSlowPath(l3, l4, l5);
                switch (n3) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l3, objectArray, l4, messagePassingQueue$Supplier.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l4, l2)) break;
        }
        int n4 = (int)((l2 - l4) / 2L);
        for (int i2 = 0; i2 < n4; ++i2) {
            long l6 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l4 + (long)(2 * i2), l3);
            UnsafeRefArrayAccess.soElement(objectArray, l6, messagePassingQueue$Supplier.get());
        }
        return n4;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            if (this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0) continue;
            int n2 = 0;
            while (messagePassingQueue$ExitCondition.keepRunning() && this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
            }
        }
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n2) {
        E e2;
        int n3;
        for (n3 = 0; n3 < n2 && (e2 = this.relaxedPoll()) != null; ++n3) {
            messagePassingQueue$Consumer.accept(e2);
        }
        return n3;
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        int n2 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            E e2 = this.relaxedPoll();
            if (e2 == null) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
                continue;
            }
            n2 = 0;
            messagePassingQueue$Consumer.accept(e2);
        }
    }

    private void resize(long l2, E[] EArray, long l3, E e2) {
        int n2 = this.getNextBufferSize(EArray);
        E[] EArray2 = CircularArrayOffsetCalculator.allocate(n2);
        this.producerBuffer = EArray2;
        int n3 = n2 - 2 << 1;
        this.producerMask = n3;
        long l4 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l3, l2);
        long l5 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l3, n3);
        UnsafeRefArrayAccess.soElement(EArray2, l5, e2);
        UnsafeRefArrayAccess.soElement(EArray, this.nextArrayOffset(l2), EArray2);
        long l6 = this.lvConsumerIndex();
        long l7 = this.availableInQueue(l3, l6);
        RangeUtil.checkPositive(l7, "availableInQueue");
        this.soProducerLimit(l3 + Math.min((long)n3, l7));
        this.soProducerIndex(l3 + 2L);
        UnsafeRefArrayAccess.soElement(EArray, l4, JUMP);
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

