/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadLocalRandom$1;
import io.netty.util.internal.ThreadLocalRandom$2;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadLocalRandom
extends Random {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ThreadLocalRandom.class);
    private static final AtomicLong seedUniquifier = new AtomicLong();
    private static volatile long initialSeedUniquifier = SystemPropertyUtil.getLong("io.netty.initialSeedUniquifier", 0L);
    private static final Thread seedGeneratorThread;
    private static final BlockingQueue<Long> seedQueue;
    private static final long seedGeneratorStartTime;
    private static volatile long seedGeneratorEndTime;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long rnd;
    boolean initialized = true;
    private long pad0;
    private long pad1;
    private long pad2;
    private long pad3;
    private long pad4;
    private long pad5;
    private long pad6;
    private long pad7;
    private static final long serialVersionUID = -5851777807851030925L;

    public static void setInitialSeedUniquifier(long l2) {
        initialSeedUniquifier = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getInitialSeedUniquifier() {
        long l2 = initialSeedUniquifier;
        if (l2 != 0L) {
            return l2;
        }
        Class<ThreadLocalRandom> clazz = ThreadLocalRandom.class;
        synchronized (ThreadLocalRandom.class) {
            boolean bl2;
            block10: {
                long l3;
                l2 = initialSeedUniquifier;
                if (l2 != 0L) {
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return l2;
                }
                long l4 = 3L;
                long l5 = seedGeneratorStartTime + TimeUnit.SECONDS.toNanos(3L);
                bl2 = false;
                do {
                    l3 = l5 - System.nanoTime();
                    try {
                        Long l6 = l3 <= 0L ? (Long)seedQueue.poll() : seedQueue.poll(l3, TimeUnit.NANOSECONDS);
                        if (l6 == null) continue;
                        l2 = l6;
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                        logger.warn("Failed to generate a seed from SecureRandom due to an InterruptedException.");
                    }
                    break block10;
                } while (l3 > 0L);
                seedGeneratorThread.interrupt();
                logger.warn("Failed to generate a seed from SecureRandom within {} seconds. Not enough entropy?", (Object)3L);
            }
            l2 ^= 0x3255ECDC33BAE119L;
            initialSeedUniquifier = l2 ^= Long.reverse(System.nanoTime());
            if (bl2) {
                Thread.currentThread().interrupt();
                seedGeneratorThread.interrupt();
            }
            if (seedGeneratorEndTime == 0L) {
                seedGeneratorEndTime = System.nanoTime();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return l2;
        }
    }

    private static long newSeed() {
        long l2;
        long l3;
        long l4;
        while (!seedUniquifier.compareAndSet(l4, l3 = (l2 = (l4 = seedUniquifier.get()) != 0L ? l4 : ThreadLocalRandom.getInitialSeedUniquifier()) * 181783497276652981L)) {
        }
        if (l4 == 0L && logger.isDebugEnabled()) {
            if (seedGeneratorEndTime != 0L) {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x (took %d ms)", l2, TimeUnit.NANOSECONDS.toMillis(seedGeneratorEndTime - seedGeneratorStartTime)));
            } else {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x", l2));
            }
        }
        return l3 ^ System.nanoTime();
    }

    private static long mix64(long l2) {
        l2 = (l2 ^ l2 >>> 33) * -49064778989728563L;
        l2 = (l2 ^ l2 >>> 33) * -4265267296055464877L;
        return l2 ^ l2 >>> 33;
    }

    ThreadLocalRandom() {
        super(ThreadLocalRandom.newSeed());
    }

    public static ThreadLocalRandom current() {
        return InternalThreadLocalMap.get().random();
    }

    @Override
    public void setSeed(long l2) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        this.rnd = (l2 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    protected int next(int n2) {
        this.rnd = this.rnd * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.rnd >>> 48 - n2);
    }

    @Override
    public int nextInt(int n2, int n3) {
        if (n2 >= n3) {
            throw new IllegalArgumentException();
        }
        return this.nextInt(n3 - n2) + n2;
    }

    @Override
    public long nextLong(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        long l3 = 0L;
        while (l2 >= Integer.MAX_VALUE) {
            long l4;
            int n2 = this.next(2);
            long l5 = l2 >>> 1;
            long l6 = l4 = (n2 & 2) == 0 ? l5 : l2 - l5;
            if ((n2 & 1) == 0) {
                l3 += l2 - l4;
            }
            l2 = l4;
        }
        return l3 + (long)this.nextInt((int)l2);
    }

    @Override
    public long nextLong(long l2, long l3) {
        if (l2 >= l3) {
            throw new IllegalArgumentException();
        }
        return this.nextLong(l3 - l2) + l2;
    }

    @Override
    public double nextDouble(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("n must be positive");
        }
        return this.nextDouble() * d2;
    }

    @Override
    public double nextDouble(double d2, double d3) {
        if (d2 >= d3) {
            throw new IllegalArgumentException();
        }
        return this.nextDouble() * (d3 - d2) + d2;
    }

    static /* synthetic */ long access$002(long l2) {
        seedGeneratorEndTime = l2;
        return seedGeneratorEndTime;
    }

    static /* synthetic */ BlockingQueue access$100() {
        return seedQueue;
    }

    static /* synthetic */ InternalLogger access$200() {
        return logger;
    }

    static {
        if (initialSeedUniquifier == 0L) {
            boolean bl2 = SystemPropertyUtil.getBoolean("java.util.secureRandomSeed", false);
            if (bl2) {
                seedQueue = new LinkedBlockingQueue<Long>();
                seedGeneratorStartTime = System.nanoTime();
                seedGeneratorThread = new ThreadLocalRandom$1("initialSeedUniquifierGenerator");
                seedGeneratorThread.setDaemon(true);
                seedGeneratorThread.setUncaughtExceptionHandler(new ThreadLocalRandom$2());
                seedGeneratorThread.start();
            } else {
                initialSeedUniquifier = ThreadLocalRandom.mix64(System.currentTimeMillis()) ^ ThreadLocalRandom.mix64(System.nanoTime());
                seedGeneratorThread = null;
                seedQueue = null;
                seedGeneratorStartTime = 0L;
            }
        } else {
            seedGeneratorThread = null;
            seedQueue = null;
            seedGeneratorStartTime = 0L;
        }
    }
}

