/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    private StringUtil() {
    }

    public static String substringAfter(String string, char c2) {
        int n2 = string.indexOf(c2);
        if (n2 >= 0) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    public static boolean commonSuffixOfLength(String string, String string2, int n2) {
        return string != null && string2 != null && n2 >= 0 && string.regionMatches(string.length() - n2, string2, string2.length() - n2, n2);
    }

    public static String byteToHexStringPadded(int n2) {
        return BYTE2HEX_PAD[n2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T t2, int n2) {
        try {
            t2.append(StringUtil.byteToHexStringPadded(n2));
        }
        catch (IOException iOException) {
            PlatformDependent.throwException(iOException);
        }
        return t2;
    }

    public static String toHexStringPadded(byte[] byArray) {
        return StringUtil.toHexStringPadded(byArray, 0, byArray.length);
    }

    public static String toHexStringPadded(byte[] byArray, int n2, int n3) {
        return StringUtil.toHexStringPadded(new StringBuilder(n3 << 1), byArray, n2, n3).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T t2, byte[] byArray) {
        return StringUtil.toHexStringPadded(t2, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T t2, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            StringUtil.byteToHexStringPadded(t2, byArray[i2]);
        }
        return t2;
    }

    public static String byteToHexString(int n2) {
        return BYTE2HEX_NOPAD[n2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T t2, int n2) {
        try {
            t2.append(StringUtil.byteToHexString(n2));
        }
        catch (IOException iOException) {
            PlatformDependent.throwException(iOException);
        }
        return t2;
    }

    public static String toHexString(byte[] byArray) {
        return StringUtil.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        return StringUtil.toHexString(new StringBuilder(n3 << 1), byArray, n2, n3).toString();
    }

    public static <T extends Appendable> T toHexString(T t2, byte[] byArray) {
        return StringUtil.toHexString(t2, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexString(T t2, byte[] byArray, int n2, int n3) {
        int n4;
        assert (n3 >= 0);
        if (n3 == 0) {
            return t2;
        }
        int n5 = n2 + n3;
        int n6 = n5 - 1;
        for (n4 = n2; n4 < n6 && byArray[n4] == 0; ++n4) {
        }
        StringUtil.byteToHexString(t2, byArray[n4++]);
        int n7 = n5 - n4;
        StringUtil.toHexStringPadded(t2, byArray, n4, n7);
        return t2;
    }

    public static int decodeHexNibble(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 55;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 87;
        }
        return -1;
    }

    public static byte decodeHexByte(CharSequence charSequence, int n2) {
        int n3 = StringUtil.decodeHexNibble(charSequence.charAt(n2));
        int n4 = StringUtil.decodeHexNibble(charSequence.charAt(n2 + 1));
        if (n3 == -1 || n4 == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", charSequence.subSequence(n2, n2 + 2), n2, charSequence));
        }
        return (byte)((n3 << 4) + n4);
    }

    public static byte[] decodeHexDump(CharSequence charSequence, int n2, int n3) {
        if (n3 < 0 || (n3 & 1) != 0) {
            throw new IllegalArgumentException("length: " + n3);
        }
        if (n3 == 0) {
            return EmptyArrays.EMPTY_BYTES;
        }
        byte[] byArray = new byte[n3 >>> 1];
        for (int i2 = 0; i2 < n3; i2 += 2) {
            byArray[i2 >>> 1] = StringUtil.decodeHexByte(charSequence, n2 + i2);
        }
        return byArray;
    }

    public static byte[] decodeHexDump(CharSequence charSequence) {
        return StringUtil.decodeHexDump(charSequence, 0, charSequence.length());
    }

    public static String simpleClassName(Object object) {
        if (object == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String string = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int n2 = string.lastIndexOf(46);
        if (n2 > -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static CharSequence escapeCsv(CharSequence charSequence) {
        return StringUtil.escapeCsv(charSequence, false);
    }

    public static CharSequence escapeCsv(CharSequence charSequence, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (bl2) {
            n4 = StringUtil.indexOfFirstNonOwsChar(charSequence, n5);
            n3 = StringUtil.indexOfLastNonOwsChar(charSequence, n4, n5);
        } else {
            n4 = 0;
            n3 = n5 - 1;
        }
        if (n4 > n3) {
            return EMPTY_STRING;
        }
        int n6 = -1;
        boolean bl3 = false;
        if (StringUtil.isDoubleQuote(charSequence.charAt(n4))) {
            boolean bl4 = bl3 = StringUtil.isDoubleQuote(charSequence.charAt(n3)) && n3 > n4;
            if (bl3) {
                ++n4;
                --n3;
            } else {
                n6 = n4;
            }
        }
        if (n6 < 0) {
            int n7;
            if (bl3) {
                for (n7 = n4; n7 <= n3; ++n7) {
                    if (!StringUtil.isDoubleQuote(charSequence.charAt(n7))) continue;
                    if (n7 == n3 || !StringUtil.isDoubleQuote(charSequence.charAt(n7 + 1))) {
                        n6 = n7;
                        break;
                    }
                    ++n7;
                }
            } else {
                for (n7 = n4; n7 <= n3; ++n7) {
                    n2 = charSequence.charAt(n7);
                    if (n2 == 10 || n2 == 13 || n2 == 44) {
                        n6 = n7;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote((char)n2)) continue;
                    if (n7 == n3 || !StringUtil.isDoubleQuote(charSequence.charAt(n7 + 1))) {
                        n6 = n7;
                        break;
                    }
                    ++n7;
                }
            }
            if (n6 < 0) {
                return bl3 ? charSequence.subSequence(n4 - 1, n3 + 2) : charSequence.subSequence(n4, n3 + 1);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n4 + 1 + 7);
        stringBuilder.append('\"').append(charSequence, n4, n6);
        for (n2 = n6; n2 <= n3; ++n2) {
            char c2 = charSequence.charAt(n2);
            if (StringUtil.isDoubleQuote(c2)) {
                stringBuilder.append('\"');
                if (n2 < n3 && StringUtil.isDoubleQuote(charSequence.charAt(n2 + 1))) {
                    ++n2;
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.append('\"');
    }

    public static CharSequence unescapeCsv(CharSequence charSequence) {
        boolean bl2;
        int n2 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = n2 - 1;
        boolean bl3 = bl2 = StringUtil.isDoubleQuote(charSequence.charAt(0)) && StringUtil.isDoubleQuote(charSequence.charAt(n3)) && n2 != 1;
        if (!bl2) {
            StringUtil.validateCsvFormat(charSequence);
            return charSequence;
        }
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        for (int i2 = 1; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '\"') {
                if (StringUtil.isDoubleQuote(charSequence.charAt(i2 + 1)) && i2 + 1 != n3) {
                    ++i2;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(2);
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        boolean bl2 = false;
        int n2 = charSequence.length() - 1;
        block8: for (int i2 = 0; i2 <= n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (bl2) {
                switch (c2) {
                    case '\"': {
                        char c3;
                        if (i2 == n2) {
                            arrayList.add(stringBuilder.toString());
                            return arrayList;
                        }
                        if ((c3 = charSequence.charAt(++i2)) == '\"') {
                            stringBuilder.append('\"');
                            break;
                        }
                        if (c3 == ',') {
                            bl2 = false;
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2 - 1);
                    }
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                }
                continue;
            }
            switch (c2) {
                case ',': {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (stringBuilder.length() == 0) {
                        bl2 = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        if (bl2) {
            throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, n2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private static void validateCsvFormat(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            switch (charSequence.charAt(i2)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
            }
        }
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence charSequence, int n2) {
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + n2);
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static int indexOfNonWhiteSpace(CharSequence charSequence, int n2) {
        while (n2 < charSequence.length()) {
            if (!Character.isWhitespace(charSequence.charAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    private static boolean isDoubleQuote(char c2) {
        return c2 == '\"';
    }

    public static boolean endsWith(CharSequence charSequence, char c2) {
        int n2 = charSequence.length();
        return n2 > 0 && charSequence.charAt(n2 - 1) == c2;
    }

    public static CharSequence trimOws(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = StringUtil.indexOfFirstNonOwsChar(charSequence, n2);
        int n4 = StringUtil.indexOfLastNonOwsChar(charSequence, n3, n2);
        return n3 == 0 && n4 == n2 - 1 ? charSequence : charSequence.subSequence(n3, n4 + 1);
    }

    private static int indexOfFirstNonOwsChar(CharSequence charSequence, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && StringUtil.isOws(charSequence.charAt(n3)); ++n3) {
        }
        return n3;
    }

    private static int indexOfLastNonOwsChar(CharSequence charSequence, int n2, int n3) {
        int n4;
        for (n4 = n3 - 1; n4 > n2 && StringUtil.isOws(charSequence.charAt(n4)); --n4) {
        }
        return n4;
    }

    private static boolean isOws(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    static {
        for (int i2 = 0; i2 < BYTE2HEX_PAD.length; ++i2) {
            String string = Integer.toHexString(i2);
            StringUtil.BYTE2HEX_PAD[i2] = i2 > 15 ? string : '0' + string;
            StringUtil.BYTE2HEX_NOPAD[i2] = string;
        }
    }
}

