/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.Recycler;
import io.netty.util.Recycler$Handle;
import io.netty.util.internal.RecyclableArrayList$1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Recycler<RecyclableArrayList> RECYCLER = new RecyclableArrayList$1();
    private boolean insertSinceRecycled;
    private final Recycler$Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance() {
        return RecyclableArrayList.newInstance(8);
    }

    public static RecyclableArrayList newInstance(int n2) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n2);
        return recyclableArrayList;
    }

    private RecyclableArrayList(Recycler$Handle<RecyclableArrayList> recycler$Handle) {
        this(recycler$Handle, 8);
    }

    private RecyclableArrayList(Recycler$Handle<RecyclableArrayList> recycler$Handle, int n2) {
        super(n2);
        this.handle = recycler$Handle;
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n2, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n2, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> collection) {
        if (collection instanceof RandomAccess && collection instanceof List) {
            List list = (List)collection;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (list.get(i2) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        } else {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        }
    }

    @Override
    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        if (super.add(object)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public void add(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        super.add(n2, object);
        this.insertSinceRecycled = true;
    }

    @Override
    public Object set(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        Object object2 = super.set(n2, object);
        this.insertSinceRecycled = true;
        return object2;
    }

    public boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }

    /* synthetic */ RecyclableArrayList(Recycler$Handle recycler$Handle, RecyclableArrayList$1 var2_2) {
        this(recycler$Handle);
    }
}

