/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.Collection;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException(string);
        }
        return t2;
    }

    public static int checkPositive(int n2, String string) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(string + ": " + n2 + " (expected: > 0)");
        }
        return n2;
    }

    public static long checkPositive(long l2, String string) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(string + ": " + l2 + " (expected: > 0)");
        }
        return l2;
    }

    public static int checkPositiveOrZero(int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException(string + ": " + n2 + " (expected: >= 0)");
        }
        return n2;
    }

    public static long checkPositiveOrZero(long l2, String string) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + ": " + l2 + " (expected: >= 0)");
        }
        return l2;
    }

    public static <T> T[] checkNonEmpty(T[] TArray, String string) {
        ObjectUtil.checkNotNull(TArray, string);
        ObjectUtil.checkPositive(TArray.length, string + ".length");
        return TArray;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T t2, String string) {
        ObjectUtil.checkNotNull(t2, string);
        ObjectUtil.checkPositive(t2.size(), string + ".size");
        return t2;
    }

    public static int intValue(Integer n2, int n3) {
        return n2 != null ? n2 : n3;
    }

    public static long longValue(Long l2, long l3) {
        return l2 != null ? l2 : l3;
    }
}

