/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.NativeLibraryLoader$1;
import io.netty.util.internal.NativeLibraryLoader$2;
import io.netty.util.internal.NativeLibraryLoader$NoexecVolumeDetector;
import io.netty.util.internal.NativeLibraryUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;

    public static void loadFirstAvailable(ClassLoader classLoader, String ... stringArray) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (String string : stringArray) {
            try {
                NativeLibraryLoader.load(string, classLoader);
                return;
            }
            catch (Throwable throwable) {
                arrayList.add(throwable);
                logger.debug("Unable to load the library '{}', trying next name...", (Object)string, (Object)throwable);
            }
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString(stringArray));
        ThrowableUtil.addSuppressedAndClear(illegalArgumentException, arrayList);
        throw illegalArgumentException;
    }

    private static String calculatePackagePrefix() {
        String string;
        String string2 = NativeLibraryLoader.class.getName();
        if (!string2.endsWith(string = "io!netty!util!internal!NativeLibraryLoader".replace('!', '.'))) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", string, string2));
        }
        return string2.substring(0, string2.length() - string.length());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String string, ClassLoader classLoader) {
        String string2 = NativeLibraryLoader.calculatePackagePrefix().replace('.', '_') + string;
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            NativeLibraryLoader.loadLibrary(classLoader, string2, false);
            return;
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
            logger.debug("{} cannot be loaded from java.libary.path, now trying export to -Dio.netty.native.workdir: {}", string2, WORKDIR, throwable);
            String string3 = System.mapLibraryName(string2);
            String string4 = NATIVE_RESOURCE_HOME + string3;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            File file = null;
            URL uRL = classLoader == null ? ClassLoader.getSystemResource(string4) : classLoader.getResource(string4);
            try {
                int n2;
                if (uRL == null) {
                    if (!PlatformDependent.isOsx()) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(string4);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                    String string5 = string4.endsWith(".jnilib") ? "META-INF/native/lib" + string2 + ".dynlib" : "META-INF/native/lib" + string2 + ".jnilib";
                    uRL = classLoader == null ? ClassLoader.getSystemResource(string5) : classLoader.getResource(string5);
                    if (uRL == null) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(string5);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                }
                int n3 = string3.lastIndexOf(46);
                String string6 = string3.substring(0, n3);
                String string7 = string3.substring(n3, string3.length());
                file = File.createTempFile(string6, string7, WORKDIR);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                }
                fileOutputStream.flush();
                NativeLibraryLoader.closeQuietly(fileOutputStream);
                fileOutputStream = null;
                NativeLibraryLoader.loadLibrary(classLoader, file.getPath(), true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    try {
                        if (file != null && file.isFile() && file.canRead() && !NativeLibraryLoader$NoexecVolumeDetector.access$000(file)) {
                            logger.info("{} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -Dio.netty.native.workdir=[path] to set native working directory separately.", (Object)file.getPath());
                        }
                    }
                    catch (Throwable throwable2) {
                        arrayList.add(throwable2);
                        logger.debug("Error checking if {} is on a file store mounted with noexec", (Object)file, (Object)throwable2);
                    }
                    ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError, arrayList);
                    throw unsatisfiedLinkError;
                    catch (Exception exception) {
                        UnsatisfiedLinkError unsatisfiedLinkError2 = new UnsatisfiedLinkError("could not load a native library: " + string2);
                        unsatisfiedLinkError2.initCause(exception);
                        ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError2, arrayList);
                        throw unsatisfiedLinkError2;
                    }
                }
                catch (Throwable throwable3) {
                    NativeLibraryLoader.closeQuietly(inputStream);
                    NativeLibraryLoader.closeQuietly(fileOutputStream);
                    if (file == null) throw throwable3;
                    if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                        if (file.delete()) throw throwable3;
                    }
                    file.deleteOnExit();
                    throw throwable3;
                }
            }
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(fileOutputStream);
            if (file == null) return;
            if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                if (file.delete()) return;
            }
            file.deleteOnExit();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadLibrary(ClassLoader classLoader, String string, boolean bl2) {
        Throwable throwable = null;
        try {
            Class<?> clazz = NativeLibraryLoader.tryToLoadClass(classLoader, NativeLibraryUtil.class);
            NativeLibraryLoader.loadLibraryByHelper(clazz, string, bl2);
            logger.debug("Successfully loaded the library {}", (Object)string);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                block5: {
                    throwable = unsatisfiedLinkError;
                    logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)unsatisfiedLinkError);
                    break block5;
                    catch (Exception exception) {
                        throwable = exception;
                        logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)exception);
                    }
                }
                NativeLibraryUtil.loadLibrary(string, bl2);
                logger.debug("Successfully loaded the library {}", (Object)string);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (throwable == null) throw unsatisfiedLinkError2;
                ThrowableUtil.addSuppressed((Throwable)unsatisfiedLinkError2, throwable);
                throw unsatisfiedLinkError2;
            }
        }
    }

    private static void loadLibraryByHelper(Class<?> clazz, String string, boolean bl2) {
        Object object = AccessController.doPrivileged(new NativeLibraryLoader$1(clazz, string, bl2));
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            assert (!(throwable instanceof UnsatisfiedLinkError)) : throwable + " should be a wrapper throwable";
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof UnsatisfiedLinkError) {
                throw (UnsatisfiedLinkError)throwable2;
            }
            UnsatisfiedLinkError unsatisfiedLinkError = new UnsatisfiedLinkError(throwable.getMessage());
            unsatisfiedLinkError.initCause(throwable);
            throw unsatisfiedLinkError;
        }
    }

    private static Class<?> tryToLoadClass(ClassLoader classLoader, Class<?> clazz) {
        try {
            return Class.forName(clazz.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader == null) {
                throw classNotFoundException;
            }
            try {
                byte[] byArray = NativeLibraryLoader.classToByteArray(clazz);
                return (Class)AccessController.doPrivileged(new NativeLibraryLoader$2(classLoader, clazz, byArray));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ThrowableUtil.addSuppressed((Throwable)classNotFoundException2, classNotFoundException);
                throw classNotFoundException2;
            }
            catch (RuntimeException runtimeException) {
                ThrowableUtil.addSuppressed((Throwable)runtimeException, classNotFoundException);
                throw runtimeException;
            }
            catch (Error error) {
                ThrowableUtil.addSuppressed((Throwable)error, classNotFoundException);
                throw error;
            }
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) {
        URL uRL;
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        if ((uRL = clazz.getResource(string + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputStream inputStream = null;
        try {
            int n3;
            inputStream = uRL.openStream();
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(clazz.getName(), iOException);
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(byteArrayOutputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        String string = SystemPropertyUtil.get("io.netty.native.workdir");
        if (string != null) {
            File file = new File(string);
            file.mkdirs();
            try {
                file = file.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = file;
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR);
        } else {
            WORKDIR = PlatformDependent.tmpdir();
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = SystemPropertyUtil.getBoolean("io.netty.native.deleteLibAfterLoading", true);
    }
}

