/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

public final class MathUtil {
    private MathUtil() {
    }

    public static int findNextPositivePowerOfTwo(int n2) {
        assert (n2 > Integer.MIN_VALUE && n2 < 0x40000000);
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    public static int safeFindNextPositivePowerOfTwo(int n2) {
        return n2 <= 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : MathUtil.findNextPositivePowerOfTwo(n2));
    }

    public static boolean isOutOfBounds(int n2, int n3, int n4) {
        return (n2 | n3 | n2 + n3 | n4 - (n2 + n3)) < 0;
    }

    public static int compare(int n2, int n3) {
        return n2 < n3 ? -1 : (n2 > n3 ? 1 : 0);
    }

    public static int compare(long l2, long l3) {
        return l2 < l3 ? -1 : (l2 > l3 ? 1 : 0);
    }
}

