/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.DefaultPriorityQueue$PriorityQueueIterator;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public final class DefaultPriorityQueue<T extends PriorityQueueNode>
extends AbstractQueue<T>
implements PriorityQueue<T> {
    private static final PriorityQueueNode[] EMPTY_ARRAY = new PriorityQueueNode[0];
    private final Comparator<T> comparator;
    private T[] queue;
    private int size;

    public DefaultPriorityQueue(Comparator<T> comparator, int n2) {
        this.comparator = ObjectUtil.checkNotNull(comparator, "comparator");
        this.queue = n2 != 0 ? new PriorityQueueNode[n2] : EMPTY_ARRAY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof PriorityQueueNode)) {
            return false;
        }
        PriorityQueueNode priorityQueueNode = (PriorityQueueNode)object;
        return this.contains(priorityQueueNode, priorityQueueNode.priorityQueueIndex(this));
    }

    @Override
    public boolean containsTyped(T t2) {
        return this.contains((PriorityQueueNode)t2, t2.priorityQueueIndex(this));
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            T t2 = this.queue[i2];
            if (t2 == null) continue;
            t2.priorityQueueIndex(this, -1);
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public void clearIgnoringIndexes() {
        this.size = 0;
    }

    @Override
    public boolean offer(T t2) {
        if (t2.priorityQueueIndex(this) != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + t2.priorityQueueIndex(this) + " (expected: " + -1 + ") + e: " + t2);
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        this.bubbleUp(this.size++, t2);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T t2 = this.queue[0];
        t2.priorityQueueIndex(this, -1);
        T t3 = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            this.bubbleDown(0, t3);
        }
        return t2;
    }

    @Override
    public T peek() {
        return this.size == 0 ? null : (T)this.queue[0];
    }

    @Override
    public boolean remove(Object object) {
        PriorityQueueNode priorityQueueNode;
        try {
            priorityQueueNode = (PriorityQueueNode)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.removeTyped((T)priorityQueueNode);
    }

    @Override
    public boolean removeTyped(T t2) {
        int n2 = t2.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t2, n2)) {
            return false;
        }
        t2.priorityQueueIndex(this, -1);
        if (--this.size == 0 || this.size == n2) {
            this.queue[n2] = null;
            return true;
        }
        T t3 = this.queue[n2] = this.queue[this.size];
        this.queue[this.size] = null;
        if (this.comparator.compare(t2, t3) < 0) {
            this.bubbleDown(n2, t3);
        } else {
            this.bubbleUp(n2, t3);
        }
        return true;
    }

    @Override
    public void priorityChanged(T t2) {
        int n2 = t2.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t2, n2)) {
            return;
        }
        if (n2 == 0) {
            this.bubbleDown(n2, t2);
        } else {
            int n3 = n2 - 1 >>> 1;
            T t3 = this.queue[n3];
            if (this.comparator.compare(t2, t3) < 0) {
                this.bubbleUp(n2, t2);
            } else {
                this.bubbleDown(n2, t2);
            }
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <X> X[] toArray(X[] XArray) {
        if (XArray.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, XArray.getClass());
        }
        System.arraycopy(this.queue, 0, XArray, 0, this.size);
        if (XArray.length > this.size) {
            XArray[this.size] = null;
        }
        return XArray;
    }

    @Override
    public Iterator<T> iterator() {
        return new DefaultPriorityQueue$PriorityQueueIterator(this, null);
    }

    private boolean contains(PriorityQueueNode priorityQueueNode, int n2) {
        return n2 >= 0 && n2 < this.size && priorityQueueNode.equals(this.queue[n2]);
    }

    private void bubbleDown(int n2, T t2) {
        int n3 = this.size >>> 1;
        while (n2 < n3) {
            int n4 = (n2 << 1) + 1;
            T t3 = this.queue[n4];
            int n5 = n4 + 1;
            if (n5 < this.size && this.comparator.compare(t3, this.queue[n5]) > 0) {
                n4 = n5;
                t3 = this.queue[n4];
            }
            if (this.comparator.compare(t2, t3) <= 0) break;
            this.queue[n2] = t3;
            t3.priorityQueueIndex(this, n2);
            n2 = n4;
        }
        this.queue[n2] = t2;
        t2.priorityQueueIndex(this, n2);
    }

    private void bubbleUp(int n2, T t2) {
        int n3;
        T t3;
        while (n2 > 0 && this.comparator.compare(t2, t3 = this.queue[n3 = n2 - 1 >>> 1]) < 0) {
            this.queue[n2] = t3;
            t3.priorityQueueIndex(this, n2);
            n2 = n3;
        }
        this.queue[n2] = t2;
        t2.priorityQueueIndex(this, n2);
    }

    static /* synthetic */ int access$100(DefaultPriorityQueue defaultPriorityQueue) {
        return defaultPriorityQueue.size;
    }

    static /* synthetic */ PriorityQueueNode[] access$200(DefaultPriorityQueue defaultPriorityQueue) {
        return defaultPriorityQueue.queue;
    }
}

