/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.concurrent.SingleThreadEventExecutor$1;
import io.netty.util.concurrent.SingleThreadEventExecutor$2;
import io.netty.util.concurrent.SingleThreadEventExecutor$3;
import io.netty.util.concurrent.SingleThreadEventExecutor$4;
import io.netty.util.concurrent.SingleThreadEventExecutor$5;
import io.netty.util.concurrent.SingleThreadEventExecutor$DefaultThreadProperties;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import io.netty.util.concurrent.ThreadProperties;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final int ST_NOT_STARTED = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_SHUTTING_DOWN = 3;
    private static final int ST_SHUTDOWN = 4;
    private static final int ST_TERMINATED = 5;
    private static final Runnable WAKEUP_TASK = new SingleThreadEventExecutor$1();
    private static final Runnable NOOP_TASK = new SingleThreadEventExecutor$2();
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final Semaphore threadLock = new Semaphore(0);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, ThreadFactory threadFactory, boolean bl2) {
        this(eventExecutorGroup, new ThreadPerTaskExecutor(threadFactory), bl2);
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, ThreadFactory threadFactory, boolean bl2, int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        this(eventExecutorGroup, new ThreadPerTaskExecutor(threadFactory), bl2, n2, rejectedExecutionHandler);
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl2) {
        this(eventExecutorGroup, executor, bl2, DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl2, int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventExecutorGroup);
        this.addTaskWakesUp = bl2;
        this.maxPendingTasks = Math.max(16, n2);
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.taskQueue = this.newTaskQueue(this.maxPendingTasks);
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
    }

    @Deprecated
    protected Queue<Runnable> newTaskQueue() {
        return this.newTaskQueue(this.maxPendingTasks);
    }

    protected Queue<Runnable> newTaskQueue(int n2) {
        return new LinkedBlockingQueue<Runnable>(n2);
    }

    protected void interruptThread() {
        Thread thread = this.thread;
        if (thread == null) {
            this.interrupted = true;
        } else {
            thread.interrupt();
        }
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    protected static Runnable pollTaskFrom(Queue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) == WAKEUP_TASK) {
        }
        return runnable;
    }

    protected Runnable takeTask() {
        Runnable runnable;
        assert (this.inEventLoop());
        if (!(this.taskQueue instanceof BlockingQueue)) {
            throw new UnsupportedOperationException();
        }
        BlockingQueue blockingQueue = (BlockingQueue)this.taskQueue;
        do {
            ScheduledFutureTask<?> scheduledFutureTask;
            if ((scheduledFutureTask = this.peekScheduledTask()) == null) {
                Runnable runnable2 = null;
                try {
                    runnable2 = (Runnable)blockingQueue.take();
                    if (runnable2 == WAKEUP_TASK) {
                        runnable2 = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return runnable2;
            }
            long l2 = scheduledFutureTask.delayNanos();
            runnable = null;
            if (l2 > 0L) {
                try {
                    runnable = (Runnable)blockingQueue.poll(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (runnable != null) continue;
            this.fetchFromScheduledTaskQueue();
            runnable = (Runnable)blockingQueue.poll();
        } while (runnable == null);
        return runnable;
    }

    private boolean fetchFromScheduledTaskQueue() {
        long l2 = AbstractScheduledEventExecutor.nanoTime();
        Runnable runnable = this.pollScheduledTask(l2);
        while (runnable != null) {
            if (!this.taskQueue.offer(runnable)) {
                this.scheduledTaskQueue().add((ScheduledFutureTask)runnable);
                return false;
            }
            runnable = this.pollScheduledTask(l2);
        }
        return true;
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        return this.taskQueue.peek();
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    public int pendingTasks() {
        return this.taskQueue.size();
    }

    protected void addTask(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        if (!this.offerTask(runnable)) {
            this.reject(runnable);
        }
    }

    final boolean offerTask(Runnable runnable) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(runnable);
    }

    protected boolean removeTask(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        return this.taskQueue.remove(runnable);
    }

    protected boolean runAllTasks() {
        boolean bl2;
        assert (this.inEventLoop());
        boolean bl3 = false;
        do {
            bl2 = this.fetchFromScheduledTaskQueue();
            if (!this.runAllTasksFrom(this.taskQueue)) continue;
            bl3 = true;
        } while (!bl2);
        if (bl3) {
            this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        this.afterRunningAllTasks();
        return bl3;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> queue) {
        Runnable runnable = SingleThreadEventExecutor.pollTaskFrom(queue);
        if (runnable == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(runnable);
        } while ((runnable = SingleThreadEventExecutor.pollTaskFrom(queue)) != null);
        return true;
    }

    protected boolean runAllTasks(long l2) {
        long l3;
        block2: {
            this.fetchFromScheduledTaskQueue();
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long l4 = ScheduledFutureTask.nanoTime() + l2;
            long l5 = 0L;
            do {
                SingleThreadEventExecutor.safeExecute(runnable);
                if ((++l5 & 0x3FL) == 0L && (l3 = ScheduledFutureTask.nanoTime()) >= l4) break block2;
            } while ((runnable = this.pollTask()) != null);
            l3 = ScheduledFutureTask.nanoTime();
        }
        this.afterRunningAllTasks();
        this.lastExecutionTime = l3;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    protected long delayNanos(long l2) {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return scheduledFutureTask.delayNanos(l2);
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = ScheduledFutureTask.nanoTime();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean bl2) {
        if (!bl2 || this.state == 3) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public void addShutdownHook(Runnable runnable) {
        if (this.inEventLoop()) {
            this.shutdownHooks.add(runnable);
        } else {
            this.execute(new SingleThreadEventExecutor$3(this, runnable));
        }
    }

    public void removeShutdownHook(Runnable runnable) {
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(runnable);
        } else {
            this.execute(new SingleThreadEventExecutor$4(this, runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        boolean bl2 = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable runnable : arrayList) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    logger.warn("Shutdown hook raised an exception.", throwable);
                }
                finally {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        return bl2;
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        boolean bl2;
        int n2;
        int n3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("quietPeriod: " + l2 + " (expected >= 0)");
        }
        if (l3 < l2) {
            throw new IllegalArgumentException("timeout: " + l3 + " (expected >= quietPeriod (" + l2 + "))");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean bl3 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            bl2 = true;
            n3 = this.state;
            if (bl3) {
                n2 = 3;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = n3;
                    bl2 = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        this.gracefulShutdownQuietPeriod = timeUnit.toNanos(l2);
        this.gracefulShutdownTimeout = timeUnit.toNanos(l3);
        if (n3 == 1) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 5);
                this.terminationFuture.tryFailure(throwable);
                if (!(throwable instanceof Exception)) {
                    PlatformDependent.throwException(throwable);
                }
                return this.terminationFuture;
            }
        }
        if (bl2) {
            this.wakeup(bl3);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        boolean bl2;
        int n2;
        int n3;
        if (this.isShutdown()) {
            return;
        }
        boolean bl3 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            bl2 = true;
            n3 = this.state;
            if (bl3) {
                n2 = 4;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    n2 = 4;
                    break;
                }
                default: {
                    n2 = n3;
                    bl2 = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        if (n3 == 1) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 5);
                this.terminationFuture.tryFailure(throwable);
                if (!(throwable instanceof Exception)) {
                    PlatformDependent.throwException(throwable);
                }
                return;
            }
        }
        if (bl2) {
            this.wakeup(bl3);
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = ScheduledFutureTask.nanoTime();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.wakeup(true);
            return false;
        }
        long l2 = ScheduledFutureTask.nanoTime();
        if (this.isShutdown() || l2 - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (l2 - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.wakeup(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        if (this.threadLock.tryAcquire(l2, timeUnit)) {
            this.threadLock.release();
        }
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        boolean bl2 = this.inEventLoop();
        this.addTask(runnable);
        if (!bl2) {
            this.startThread();
            if (this.isShutdown() && this.removeTask(runnable)) {
                SingleThreadEventExecutor.reject();
            }
        }
        if (!this.addTaskWakesUp && this.wakesUpForTask(runnable)) {
            this.wakeup(bl2);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection, l2, timeUnit);
    }

    private void throwIfInEventLoop(String string) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + string + " from within the EventLoop is not allowed");
        }
    }

    public final ThreadProperties threadProperties() {
        ThreadProperties threadProperties = this.threadProperties;
        if (threadProperties == null) {
            Thread thread = this.thread;
            if (thread == null) {
                assert (!this.inEventLoop());
                this.submit(NOOP_TASK).syncUninterruptibly();
                thread = this.thread;
                assert (thread != null);
            }
            if (!PROPERTIES_UPDATER.compareAndSet(this, null, threadProperties = new SingleThreadEventExecutor$DefaultThreadProperties(thread))) {
                threadProperties = this.threadProperties;
            }
        }
        return threadProperties;
    }

    protected boolean wakesUpForTask(Runnable runnable) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    protected final void reject(Runnable runnable) {
        this.rejectedExecutionHandler.rejected(runnable, this);
    }

    private void startThread() {
        if (this.state == 1 && STATE_UPDATER.compareAndSet(this, 1, 2)) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 1);
                PlatformDependent.throwException(throwable);
            }
        }
    }

    private void doStartThread() {
        assert (this.thread == null);
        this.executor.execute(new SingleThreadEventExecutor$5(this));
    }

    static /* synthetic */ Set access$000(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.shutdownHooks;
    }

    static /* synthetic */ Thread access$102(SingleThreadEventExecutor singleThreadEventExecutor, Thread thread) {
        singleThreadEventExecutor.thread = thread;
        return singleThreadEventExecutor.thread;
    }

    static /* synthetic */ boolean access$200(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.interrupted;
    }

    static /* synthetic */ Thread access$100(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.thread;
    }

    static /* synthetic */ InternalLogger access$300() {
        return logger;
    }

    static /* synthetic */ int access$400(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.state;
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$500() {
        return STATE_UPDATER;
    }

    static /* synthetic */ long access$600(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.gracefulShutdownStartTime;
    }

    static /* synthetic */ Semaphore access$700(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.threadLock;
    }

    static /* synthetic */ Queue access$800(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.taskQueue;
    }

    static /* synthetic */ Promise access$900(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.terminationFuture;
    }
}

