/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseTask$RunnableAdapter;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;

class PromiseTask<V>
extends DefaultPromise<V>
implements RunnableFuture<V> {
    protected final Callable<V> task;

    static <T> Callable<T> toCallable(Runnable runnable, T t2) {
        return new PromiseTask$RunnableAdapter<T>(runnable, t2);
    }

    PromiseTask(EventExecutor eventExecutor, Runnable runnable, V v2) {
        this(eventExecutor, PromiseTask.toCallable(runnable, v2));
    }

    PromiseTask(EventExecutor eventExecutor, Callable<V> callable) {
        super(eventExecutor);
        this.task = callable;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void run() {
        try {
            if (this.setUncancellableInternal()) {
                V v2 = this.task.call();
                this.setSuccessInternal(v2);
            }
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    @Override
    public final Promise<V> setFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    protected final Promise<V> setFailureInternal(Throwable throwable) {
        super.setFailure(throwable);
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable throwable) {
        return false;
    }

    protected final boolean tryFailureInternal(Throwable throwable) {
        return super.tryFailure(throwable);
    }

    @Override
    public final Promise<V> setSuccess(V v2) {
        throw new IllegalStateException();
    }

    protected final Promise<V> setSuccessInternal(V v2) {
        super.setSuccess(v2);
        return this;
    }

    @Override
    public final boolean trySuccess(V v2) {
        return false;
    }

    protected final boolean trySuccessInternal(V v2) {
        return super.trySuccess(v2);
    }

    @Override
    public final boolean setUncancellable() {
        throw new IllegalStateException();
    }

    protected final boolean setUncancellableInternal() {
        return super.setUncancellable();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" task: ").append(this.task).append(')');
    }
}

