/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner$1;
import io.netty.util.internal.ObjectUtil;

public final class PromiseCombiner {
    private int expectedCount;
    private int doneCount;
    private boolean doneAdding;
    private Promise<Void> aggregatePromise;
    private Throwable cause;
    private final GenericFutureListener<Future<?>> listener = new PromiseCombiner$1(this);

    @Deprecated
    public void add(Promise promise) {
        this.add((Future)promise);
    }

    public void add(Future future) {
        this.checkAddAllowed();
        ++this.expectedCount;
        future.addListener(this.listener);
    }

    @Deprecated
    public void addAll(Promise ... promiseArray) {
        this.addAll((Future[])promiseArray);
    }

    public void addAll(Future ... futureArray) {
        for (Future future : futureArray) {
            this.add(future);
        }
    }

    public void finish(Promise<Void> promise) {
        if (this.doneAdding) {
            throw new IllegalStateException("Already finished");
        }
        this.doneAdding = true;
        this.aggregatePromise = ObjectUtil.checkNotNull(promise, "aggregatePromise");
        if (this.doneCount == this.expectedCount) {
            this.tryPromise();
        }
    }

    private boolean tryPromise() {
        return this.cause == null ? this.aggregatePromise.trySuccess(null) : this.aggregatePromise.tryFailure(this.cause);
    }

    private void checkAddAllowed() {
        if (this.doneAdding) {
            throw new IllegalStateException("Adding promises is not allowed after finished adding");
        }
    }

    static /* synthetic */ int access$004(PromiseCombiner promiseCombiner) {
        return ++promiseCombiner.doneCount;
    }

    static /* synthetic */ Throwable access$100(PromiseCombiner promiseCombiner) {
        return promiseCombiner.cause;
    }

    static /* synthetic */ Throwable access$102(PromiseCombiner promiseCombiner, Throwable throwable) {
        promiseCombiner.cause = throwable;
        return promiseCombiner.cause;
    }

    static /* synthetic */ int access$000(PromiseCombiner promiseCombiner) {
        return promiseCombiner.doneCount;
    }

    static /* synthetic */ int access$200(PromiseCombiner promiseCombiner) {
        return promiseCombiner.expectedCount;
    }

    static /* synthetic */ boolean access$300(PromiseCombiner promiseCombiner) {
        return promiseCombiner.doneAdding;
    }

    static /* synthetic */ boolean access$400(PromiseCombiner promiseCombiner) {
        return promiseCombiner.tryPromise();
    }
}

