/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.AbstractScheduledEventExecutor$1;
import io.netty.util.concurrent.AbstractScheduledEventExecutor$2;
import io.netty.util.concurrent.AbstractScheduledEventExecutor$3;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    private static final Comparator<ScheduledFutureTask<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = new AbstractScheduledEventExecutor$1();
    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue;

    protected AbstractScheduledEventExecutor() {
    }

    protected AbstractScheduledEventExecutor(EventExecutorGroup eventExecutorGroup) {
        super(eventExecutorGroup);
    }

    protected static long nanoTime() {
        return ScheduledFutureTask.nanoTime();
    }

    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    protected void cancelScheduledTasks() {
        ScheduledFutureTask[] scheduledFutureTaskArray;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(priorityQueue)) {
            return;
        }
        for (ScheduledFutureTask scheduledFutureTask : scheduledFutureTaskArray = priorityQueue.toArray(new ScheduledFutureTask[priorityQueue.size()])) {
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        priorityQueue.clearIgnoringIndexes();
    }

    protected final Runnable pollScheduledTask() {
        return this.pollScheduledTask(AbstractScheduledEventExecutor.nanoTime());
    }

    protected final Runnable pollScheduledTask(long l2) {
        ScheduledFutureTask scheduledFutureTask;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        ScheduledFutureTask scheduledFutureTask2 = scheduledFutureTask = priorityQueue == null ? null : (ScheduledFutureTask)priorityQueue.peek();
        if (scheduledFutureTask == null) {
            return null;
        }
        if (scheduledFutureTask.deadlineNanos() <= l2) {
            priorityQueue.remove();
            return scheduledFutureTask;
        }
        return null;
    }

    protected final long nextScheduledTaskNano() {
        ScheduledFutureTask scheduledFutureTask;
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        ScheduledFutureTask scheduledFutureTask2 = scheduledFutureTask = priorityQueue == null ? null : (ScheduledFutureTask)priorityQueue.peek();
        if (scheduledFutureTask == null) {
            return -1L;
        }
        return Math.max(0L, scheduledFutureTask.deadlineNanos() - AbstractScheduledEventExecutor.nanoTime());
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        if (priorityQueue == null) {
            return null;
        }
        return (ScheduledFutureTask)priorityQueue.peek();
    }

    protected final boolean hasScheduledTasks() {
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        ScheduledFutureTask scheduledFutureTask = priorityQueue == null ? null : (ScheduledFutureTask)priorityQueue.peek();
        return scheduledFutureTask != null && scheduledFutureTask.deadlineNanos() <= AbstractScheduledEventExecutor.nanoTime();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.validateScheduled(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask<Object>(this, runnable, null, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.validateScheduled(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask<V>(this, callable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", l3));
        }
        this.validateScheduled(l2, timeUnit);
        this.validateScheduled(l3, timeUnit);
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(runnable, null), ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2)), timeUnit.toNanos(l3)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", l3));
        }
        this.validateScheduled(l2, timeUnit);
        this.validateScheduled(l3, timeUnit);
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(runnable, null), ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2)), -timeUnit.toNanos(l3)));
    }

    protected void validateScheduled(long l2, TimeUnit timeUnit) {
    }

    <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().add(scheduledFutureTask);
        } else {
            this.execute(new AbstractScheduledEventExecutor$2(this, scheduledFutureTask));
        }
        return scheduledFutureTask;
    }

    final void removeScheduled(ScheduledFutureTask<?> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(scheduledFutureTask);
        } else {
            this.execute(new AbstractScheduledEventExecutor$3(this, scheduledFutureTask));
        }
    }
}

