/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ShortObjectHashMap$1;
import io.netty.util.collection.ShortObjectHashMap$2;
import io.netty.util.collection.ShortObjectHashMap$EntrySet;
import io.netty.util.collection.ShortObjectHashMap$KeySet;
import io.netty.util.collection.ShortObjectMap;
import io.netty.util.collection.ShortObjectMap$PrimitiveEntry;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ShortObjectHashMap<V>
implements ShortObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private short[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Short> keySet = new ShortObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Short, V>> entrySet = new ShortObjectHashMap$EntrySet(this, null);
    private final Iterable<ShortObjectMap$PrimitiveEntry<V>> entries = new ShortObjectHashMap$1(this);

    public ShortObjectHashMap() {
        this(8, 0.5f);
    }

    public ShortObjectHashMap(int n2) {
        this(n2, 0.5f);
    }

    public ShortObjectHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        int n3 = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = n3 - 1;
        this.keys = new short[n3];
        Object[] objectArray = new Object[n3];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n3);
    }

    private static <T> T toExternal(T t2) {
        assert (t2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t2 == NULL_VALUE ? null : (T)t2;
    }

    private static <T> T toInternal(T t2) {
        return (T)(t2 == null ? NULL_VALUE : t2);
    }

    @Override
    public V get(short s2) {
        int n2 = this.indexOf(s2);
        return n2 == -1 ? null : (V)ShortObjectHashMap.toExternal(this.values[n2]);
    }

    @Override
    public V put(short s2, V v2) {
        int n2;
        int n3 = n2 = this.hashIndex(s2);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = s2;
                this.values[n3] = ShortObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != s2) continue;
            V v3 = this.values[n3];
            this.values[n3] = ShortObjectHashMap.toInternal(v2);
            return ShortObjectHashMap.toExternal(v3);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Short, ? extends V> map) {
        if (map instanceof ShortObjectHashMap) {
            ShortObjectHashMap shortObjectHashMap = (ShortObjectHashMap)map;
            for (int i2 = 0; i2 < shortObjectHashMap.values.length; ++i2) {
                V v2 = shortObjectHashMap.values[i2];
                if (v2 == null) continue;
                this.put(shortObjectHashMap.keys[i2], v2);
            }
            return;
        }
        for (Map.Entry<Short, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(short s2) {
        int n2 = this.indexOf(s2);
        if (n2 == -1) {
            return null;
        }
        V v2 = this.values[n2];
        this.removeAt(n2);
        return ShortObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(short s2) {
        return this.indexOf(s2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ShortObjectHashMap.toInternal(object);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ShortObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new ShortObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        for (short s2 : this.keys) {
            n2 ^= ShortObjectHashMap.hashCode(s2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortObjectMap)) {
            return false;
        }
        ShortObjectMap shortObjectMap = (ShortObjectMap)object;
        if (this.size != shortObjectMap.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            short s2 = this.keys[i2];
            Object v3 = shortObjectMap.get(s2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Short s2, V v2) {
        return this.put(this.objectToKey(s2), v2);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Short> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Short, V>> entrySet() {
        return this.entrySet;
    }

    private short objectToKey(Object object) {
        return (Short)object;
    }

    private int indexOf(short s2) {
        int n2;
        int n3 = n2 = this.hashIndex(s2);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (s2 != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(short s2) {
        return ShortObjectHashMap.hashCode(s2) & this.mask;
    }

    private static int hashCode(short s2) {
        return s2;
    }

    private int probeNext(int n2) {
        return n2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n2) {
        --this.size;
        this.keys[n2] = 0;
        this.values[n2] = null;
        int n3 = n2;
        int n4 = this.probeNext(n2);
        V v2 = this.values[n4];
        while (v2 != null) {
            short s2 = this.keys[n4];
            int n5 = this.hashIndex(s2);
            if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                this.keys[n3] = s2;
                this.values[n3] = v2;
                this.keys[n4] = 0;
                this.values[n4] = null;
                n3 = n4;
            }
            n4 = this.probeNext(n4);
            v2 = this.values[n4];
        }
        return n3 != n2;
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        short[] sArray = this.keys;
        V[] VArray = this.values;
        this.keys = new short[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
        this.mask = n2 - 1;
        block0: for (int i2 = 0; i2 < VArray.length; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null) continue;
            short s2 = sArray[i2];
            int n3 = this.hashIndex(s2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = s2;
                    this.values[n3] = v2;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : ShortObjectHashMap.toExternal(v2)));
            bl2 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(short s2) {
        return Short.toString(s2);
    }

    static /* synthetic */ int access$300(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(ShortObjectHashMap shortObjectHashMap, int n2) {
        return shortObjectHashMap.removeAt(n2);
    }

    static /* synthetic */ short[] access$800(ShortObjectHashMap shortObjectHashMap) {
        return shortObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return ShortObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return ShortObjectHashMap.toInternal(object);
    }
}

