/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.LongObjectHashMap$1;
import io.netty.util.collection.LongObjectHashMap$2;
import io.netty.util.collection.LongObjectHashMap$EntrySet;
import io.netty.util.collection.LongObjectHashMap$KeySet;
import io.netty.util.collection.LongObjectMap;
import io.netty.util.collection.LongObjectMap$PrimitiveEntry;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class LongObjectHashMap<V>
implements LongObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private long[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Long> keySet = new LongObjectHashMap$KeySet(this);
    private final Set<Map.Entry<Long, V>> entrySet = new LongObjectHashMap$EntrySet(this, null);
    private final Iterable<LongObjectMap$PrimitiveEntry<V>> entries = new LongObjectHashMap$1(this);

    public LongObjectHashMap() {
        this(8, 0.5f);
    }

    public LongObjectHashMap(int n2) {
        this(n2, 0.5f);
    }

    public LongObjectHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        int n3 = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = n3 - 1;
        this.keys = new long[n3];
        Object[] objectArray = new Object[n3];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n3);
    }

    private static <T> T toExternal(T t2) {
        assert (t2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t2 == NULL_VALUE ? null : (T)t2;
    }

    private static <T> T toInternal(T t2) {
        return (T)(t2 == null ? NULL_VALUE : t2);
    }

    @Override
    public V get(long l2) {
        int n2 = this.indexOf(l2);
        return n2 == -1 ? null : (V)LongObjectHashMap.toExternal(this.values[n2]);
    }

    @Override
    public V put(long l2, V v2) {
        int n2;
        int n3 = n2 = this.hashIndex(l2);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = l2;
                this.values[n3] = LongObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != l2) continue;
            V v3 = this.values[n3];
            this.values[n3] = LongObjectHashMap.toInternal(v2);
            return LongObjectHashMap.toExternal(v3);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        if (map instanceof LongObjectHashMap) {
            LongObjectHashMap longObjectHashMap = (LongObjectHashMap)map;
            for (int i2 = 0; i2 < longObjectHashMap.values.length; ++i2) {
                V v2 = longObjectHashMap.values[i2];
                if (v2 == null) continue;
                this.put(longObjectHashMap.keys[i2], v2);
            }
            return;
        }
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(long l2) {
        int n2 = this.indexOf(l2);
        if (n2 == -1) {
            return null;
        }
        V v2 = this.values[n2];
        this.removeAt(n2);
        return LongObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(long l2) {
        return this.indexOf(l2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = LongObjectHashMap.toInternal(object);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<LongObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new LongObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        for (long l2 : this.keys) {
            n2 ^= LongObjectHashMap.hashCode(l2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongObjectMap)) {
            return false;
        }
        LongObjectMap longObjectMap = (LongObjectMap)object;
        if (this.size != longObjectMap.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            long l2 = this.keys[i2];
            Object v3 = longObjectMap.get(l2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Long l2, V v2) {
        return this.put(this.objectToKey(l2), v2);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Long> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.entrySet;
    }

    private long objectToKey(Object object) {
        return (Long)object;
    }

    private int indexOf(long l2) {
        int n2;
        int n3 = n2 = this.hashIndex(l2);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (l2 != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(long l2) {
        return LongObjectHashMap.hashCode(l2) & this.mask;
    }

    private static int hashCode(long l2) {
        return (int)(l2 ^ l2 >>> 32);
    }

    private int probeNext(int n2) {
        return n2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n2) {
        --this.size;
        this.keys[n2] = 0L;
        this.values[n2] = null;
        int n3 = n2;
        int n4 = this.probeNext(n2);
        V v2 = this.values[n4];
        while (v2 != null) {
            long l2 = this.keys[n4];
            int n5 = this.hashIndex(l2);
            if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                this.keys[n3] = l2;
                this.values[n3] = v2;
                this.keys[n4] = 0L;
                this.values[n4] = null;
                n3 = n4;
            }
            n4 = this.probeNext(n4);
            v2 = this.values[n4];
        }
        return n3 != n2;
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        long[] lArray = this.keys;
        V[] VArray = this.values;
        this.keys = new long[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
        this.mask = n2 - 1;
        block0: for (int i2 = 0; i2 < VArray.length; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null) continue;
            long l2 = lArray[i2];
            int n3 = this.hashIndex(l2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = l2;
                    this.values[n3] = v2;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : LongObjectHashMap.toExternal(v2)));
            bl2 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(long l2) {
        return Long.toString(l2);
    }

    static /* synthetic */ int access$300(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(LongObjectHashMap longObjectHashMap, int n2) {
        return longObjectHashMap.removeAt(n2);
    }

    static /* synthetic */ long[] access$800(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return LongObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return LongObjectHashMap.toInternal(object);
    }
}

