/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.CharObjectHashMap$1;
import io.netty.util.collection.CharObjectHashMap$2;
import io.netty.util.collection.CharObjectHashMap$EntrySet;
import io.netty.util.collection.CharObjectHashMap$KeySet;
import io.netty.util.collection.CharObjectMap;
import io.netty.util.collection.CharObjectMap$PrimitiveEntry;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class CharObjectHashMap<V>
implements CharObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private char[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Character> keySet = new CharObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Character, V>> entrySet = new CharObjectHashMap$EntrySet(this, null);
    private final Iterable<CharObjectMap$PrimitiveEntry<V>> entries = new CharObjectHashMap$1(this);

    public CharObjectHashMap() {
        this(8, 0.5f);
    }

    public CharObjectHashMap(int n2) {
        this(n2, 0.5f);
    }

    public CharObjectHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        int n3 = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = n3 - 1;
        this.keys = new char[n3];
        Object[] objectArray = new Object[n3];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n3);
    }

    private static <T> T toExternal(T t2) {
        assert (t2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t2 == NULL_VALUE ? null : (T)t2;
    }

    private static <T> T toInternal(T t2) {
        return (T)(t2 == null ? NULL_VALUE : t2);
    }

    @Override
    public V get(char c2) {
        int n2 = this.indexOf(c2);
        return n2 == -1 ? null : (V)CharObjectHashMap.toExternal(this.values[n2]);
    }

    @Override
    public V put(char c2, V v2) {
        int n2;
        int n3 = n2 = this.hashIndex(c2);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = c2;
                this.values[n3] = CharObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != c2) continue;
            V v3 = this.values[n3];
            this.values[n3] = CharObjectHashMap.toInternal(v2);
            return CharObjectHashMap.toExternal(v3);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> map) {
        if (map instanceof CharObjectHashMap) {
            CharObjectHashMap charObjectHashMap = (CharObjectHashMap)map;
            for (int i2 = 0; i2 < charObjectHashMap.values.length; ++i2) {
                V v2 = charObjectHashMap.values[i2];
                if (v2 == null) continue;
                this.put(charObjectHashMap.keys[i2], v2);
            }
            return;
        }
        for (Map.Entry<Character, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(char c2) {
        int n2 = this.indexOf(c2);
        if (n2 == -1) {
            return null;
        }
        V v2 = this.values[n2];
        this.removeAt(n2);
        return CharObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(char c2) {
        return this.indexOf(c2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = CharObjectHashMap.toInternal(object);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<CharObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new CharObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        for (char c2 : this.keys) {
            n2 ^= CharObjectHashMap.hashCode(c2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap charObjectMap = (CharObjectMap)object;
        if (this.size != charObjectMap.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            char c2 = this.keys[i2];
            Object v3 = charObjectMap.get(c2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Character c2, V v2) {
        return this.put(this.objectToKey(c2), v2);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Character> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        return this.entrySet;
    }

    private char objectToKey(Object object) {
        return ((Character)object).charValue();
    }

    private int indexOf(char c2) {
        int n2;
        int n3 = n2 = this.hashIndex(c2);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (c2 != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(char c2) {
        return CharObjectHashMap.hashCode(c2) & this.mask;
    }

    private static int hashCode(char c2) {
        return c2;
    }

    private int probeNext(int n2) {
        return n2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n2) {
        --this.size;
        this.keys[n2] = '\u0000';
        this.values[n2] = null;
        int n3 = n2;
        int n4 = this.probeNext(n2);
        V v2 = this.values[n4];
        while (v2 != null) {
            char c2 = this.keys[n4];
            int n5 = this.hashIndex(c2);
            if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                this.keys[n3] = c2;
                this.values[n3] = v2;
                this.keys[n4] = '\u0000';
                this.values[n4] = null;
                n3 = n4;
            }
            n4 = this.probeNext(n4);
            v2 = this.values[n4];
        }
        return n3 != n2;
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        char[] cArray = this.keys;
        V[] VArray = this.values;
        this.keys = new char[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
        this.mask = n2 - 1;
        block0: for (int i2 = 0; i2 < VArray.length; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null) continue;
            char c2 = cArray[i2];
            int n3 = this.hashIndex(c2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = c2;
                    this.values[n3] = v2;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : CharObjectHashMap.toExternal(v2)));
            bl2 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(char c2) {
        return Character.toString(c2);
    }

    static /* synthetic */ int access$300(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(CharObjectHashMap charObjectHashMap, int n2) {
        return charObjectHashMap.removeAt(n2);
    }

    static /* synthetic */ char[] access$800(CharObjectHashMap charObjectHashMap) {
        return charObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return CharObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return CharObjectHashMap.toInternal(object);
    }
}

