/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ByteObjectHashMap$1;
import io.netty.util.collection.ByteObjectHashMap$2;
import io.netty.util.collection.ByteObjectHashMap$EntrySet;
import io.netty.util.collection.ByteObjectHashMap$KeySet;
import io.netty.util.collection.ByteObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ByteObjectHashMap<V>
implements ByteObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private byte[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Byte> keySet = new ByteObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Byte, V>> entrySet = new ByteObjectHashMap$EntrySet(this, null);
    private final Iterable<ByteObjectMap.PrimitiveEntry<V>> entries = new ByteObjectHashMap$1(this);

    public ByteObjectHashMap() {
        this(8, 0.5f);
    }

    public ByteObjectHashMap(int n2) {
        this(n2, 0.5f);
    }

    public ByteObjectHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        int n3 = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = n3 - 1;
        this.keys = new byte[n3];
        Object[] objectArray = new Object[n3];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n3);
    }

    private static <T> T toExternal(T t2) {
        assert (t2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t2 == NULL_VALUE ? null : (T)t2;
    }

    private static <T> T toInternal(T t2) {
        return (T)(t2 == null ? NULL_VALUE : t2);
    }

    @Override
    public V get(byte by2) {
        int n2 = this.indexOf(by2);
        return n2 == -1 ? null : (V)ByteObjectHashMap.toExternal(this.values[n2]);
    }

    @Override
    public V put(byte by2, V v2) {
        int n2;
        int n3 = n2 = this.hashIndex(by2);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = by2;
                this.values[n3] = ByteObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != by2) continue;
            V v3 = this.values[n3];
            this.values[n3] = ByteObjectHashMap.toInternal(v2);
            return ByteObjectHashMap.toExternal(v3);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends V> map) {
        if (map instanceof ByteObjectHashMap) {
            ByteObjectHashMap byteObjectHashMap = (ByteObjectHashMap)map;
            for (int i2 = 0; i2 < byteObjectHashMap.values.length; ++i2) {
                V v2 = byteObjectHashMap.values[i2];
                if (v2 == null) continue;
                this.put(byteObjectHashMap.keys[i2], v2);
            }
            return;
        }
        for (Map.Entry<Byte, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(byte by2) {
        int n2 = this.indexOf(by2);
        if (n2 == -1) {
            return null;
        }
        V v2 = this.values[n2];
        this.removeAt(n2);
        return ByteObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(byte by2) {
        return this.indexOf(by2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ByteObjectHashMap.toInternal(object);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ByteObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new ByteObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        for (byte by2 : this.keys) {
            n2 ^= ByteObjectHashMap.hashCode(by2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap byteObjectMap = (ByteObjectMap)object;
        if (this.size != byteObjectMap.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            byte by2 = this.keys[i2];
            Object v3 = byteObjectMap.get(by2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Byte by2, V v2) {
        return this.put(this.objectToKey(by2), v2);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Byte> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Byte, V>> entrySet() {
        return this.entrySet;
    }

    private byte objectToKey(Object object) {
        return (Byte)object;
    }

    private int indexOf(byte by2) {
        int n2;
        int n3 = n2 = this.hashIndex(by2);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (by2 != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(byte by2) {
        return ByteObjectHashMap.hashCode(by2) & this.mask;
    }

    private static int hashCode(byte by2) {
        return by2;
    }

    private int probeNext(int n2) {
        return n2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n2) {
        --this.size;
        this.keys[n2] = 0;
        this.values[n2] = null;
        int n3 = n2;
        int n4 = this.probeNext(n2);
        V v2 = this.values[n4];
        while (v2 != null) {
            byte by2 = this.keys[n4];
            int n5 = this.hashIndex(by2);
            if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                this.keys[n3] = by2;
                this.values[n3] = v2;
                this.keys[n4] = 0;
                this.values[n4] = null;
                n3 = n4;
            }
            n4 = this.probeNext(n4);
            v2 = this.values[n4];
        }
        return n3 != n2;
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        byte[] byArray = this.keys;
        V[] VArray = this.values;
        this.keys = new byte[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
        this.mask = n2 - 1;
        block0: for (int i2 = 0; i2 < VArray.length; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null) continue;
            byte by2 = byArray[i2];
            int n3 = this.hashIndex(by2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = by2;
                    this.values[n3] = v2;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : ByteObjectHashMap.toExternal(v2)));
            bl2 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(byte by2) {
        return Byte.toString(by2);
    }

    static /* synthetic */ int access$300(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(ByteObjectHashMap byteObjectHashMap, int n2) {
        return byteObjectHashMap.removeAt(n2);
    }

    static /* synthetic */ byte[] access$800(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return ByteObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return ByteObjectHashMap.toInternal(object);
    }
}

