/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeak;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetector$DefaultResourceLeak;
import io.netty.util.ResourceLeakDetector$Level;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ResourceLeakDetector<T> {
    private static final String PROP_LEVEL_OLD = "io.netty.leakDetectionLevel";
    private static final String PROP_LEVEL = "io.netty.leakDetection.level";
    private static final ResourceLeakDetector$Level DEFAULT_LEVEL;
    private static final String PROP_TARGET_RECORDS = "io.netty.leakDetection.targetRecords";
    private static final int DEFAULT_TARGET_RECORDS = 4;
    private static final int TARGET_RECORDS;
    private static ResourceLeakDetector$Level level;
    private static final InternalLogger logger;
    static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private final ConcurrentMap<ResourceLeakDetector$DefaultResourceLeak<?>, LeakEntry> allLeaks = PlatformDependent.newConcurrentHashMap();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentMap<String, Boolean> reportedLeaks = PlatformDependent.newConcurrentHashMap();
    private final String resourceType;
    private final int samplingInterval;
    private static final AtomicReference<String[]> excludedMethods;

    @Deprecated
    public static void setEnabled(boolean bl2) {
        ResourceLeakDetector.setLevel(bl2 ? ResourceLeakDetector$Level.SIMPLE : ResourceLeakDetector$Level.DISABLED);
    }

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > ResourceLeakDetector$Level.DISABLED.ordinal();
    }

    public static void setLevel(ResourceLeakDetector$Level resourceLeakDetector$Level) {
        if (resourceLeakDetector$Level == null) {
            throw new NullPointerException("level");
        }
        level = resourceLeakDetector$Level;
    }

    public static ResourceLeakDetector$Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz) {
        this(StringUtil.simpleClassName(clazz));
    }

    @Deprecated
    public ResourceLeakDetector(String string) {
        this(string, 128, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz, int n2, long l2) {
        this(clazz, n2);
    }

    public ResourceLeakDetector(Class<?> clazz, int n2) {
        this(StringUtil.simpleClassName(clazz), n2, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(String string, int n2, long l2) {
        if (string == null) {
            throw new NullPointerException("resourceType");
        }
        this.resourceType = string;
        this.samplingInterval = n2;
    }

    @Deprecated
    public final ResourceLeak open(T t2) {
        return this.track0(t2);
    }

    public final ResourceLeakTracker<T> track(T t2) {
        return this.track0(t2);
    }

    private ResourceLeakDetector$DefaultResourceLeak track0(T t2) {
        ResourceLeakDetector$Level resourceLeakDetector$Level = level;
        if (resourceLeakDetector$Level == ResourceLeakDetector$Level.DISABLED) {
            return null;
        }
        if (resourceLeakDetector$Level.ordinal() < ResourceLeakDetector$Level.PARANOID.ordinal()) {
            if (PlatformDependent.threadLocalRandom().nextInt(this.samplingInterval) == 0) {
                this.reportLeak();
                return new ResourceLeakDetector$DefaultResourceLeak(t2, this.refQueue, this.allLeaks);
            }
            return null;
        }
        this.reportLeak();
        return new ResourceLeakDetector$DefaultResourceLeak(t2, this.refQueue, this.allLeaks);
    }

    private void clearRefQueue() {
        ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak;
        while ((resourceLeakDetector$DefaultResourceLeak = (ResourceLeakDetector$DefaultResourceLeak)this.refQueue.poll()) != null) {
            resourceLeakDetector$DefaultResourceLeak.dispose();
        }
    }

    private void reportLeak() {
        ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak;
        if (!logger.isErrorEnabled()) {
            this.clearRefQueue();
            return;
        }
        while ((resourceLeakDetector$DefaultResourceLeak = (ResourceLeakDetector$DefaultResourceLeak)this.refQueue.poll()) != null) {
            String string;
            if (!resourceLeakDetector$DefaultResourceLeak.dispose() || this.reportedLeaks.putIfAbsent(string = resourceLeakDetector$DefaultResourceLeak.toString(), Boolean.TRUE) != null) continue;
            if (string.isEmpty()) {
                this.reportUntracedLeak(this.resourceType);
                continue;
            }
            this.reportTracedLeak(this.resourceType, string);
        }
    }

    protected void reportTracedLeak(String string, String string2) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See http://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)string, (Object)string2);
    }

    protected void reportUntracedLeak(String string) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See http://netty.io/wiki/reference-counted-objects.html for more information.", string, PROP_LEVEL, ResourceLeakDetector$Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    @Deprecated
    protected void reportInstancesLeak(String string) {
    }

    public static void addExclusions(Class clazz, String ... stringArray) {
        String[] stringArray2;
        Method method;
        int n2;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Object[] objectArray = clazz.getDeclaredMethods();
        int n3 = objectArray.length;
        for (n2 = 0; !(n2 >= n3 || hashSet.remove((method = objectArray[n2]).getName()) && hashSet.isEmpty()); ++n2) {
        }
        if (!hashSet.isEmpty()) {
            throw new IllegalArgumentException("Can't find '" + hashSet + "' in " + clazz.getName());
        }
        do {
            objectArray = excludedMethods.get();
            stringArray2 = (String[])Arrays.copyOf(objectArray, objectArray.length + 2 * stringArray.length);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray2[objectArray.length + n2 * 2] = clazz.getName();
                stringArray2[objectArray.length + n2 * 2 + 1] = stringArray[n2];
            }
        } while (!excludedMethods.compareAndSet((String[])objectArray, stringArray2));
    }

    static /* synthetic */ ResourceLeakDetector$Level access$000() {
        return DEFAULT_LEVEL;
    }

    static /* synthetic */ int access$200() {
        return TARGET_RECORDS;
    }

    static /* synthetic */ AtomicReference access$500() {
        return excludedMethods;
    }

    static {
        boolean bl2;
        DEFAULT_LEVEL = ResourceLeakDetector$Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("io.netty.noResourceLeakDetection") != null) {
            bl2 = SystemPropertyUtil.getBoolean("io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)bl2);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)PROP_LEVEL, (Object)DEFAULT_LEVEL.name().toLowerCase());
        } else {
            bl2 = false;
        }
        ResourceLeakDetector$Level resourceLeakDetector$Level = bl2 ? ResourceLeakDetector$Level.DISABLED : DEFAULT_LEVEL;
        String string = SystemPropertyUtil.get(PROP_LEVEL_OLD, resourceLeakDetector$Level.name());
        string = SystemPropertyUtil.get(PROP_LEVEL, string);
        ResourceLeakDetector$Level resourceLeakDetector$Level2 = ResourceLeakDetector$Level.parseLevel(string);
        TARGET_RECORDS = SystemPropertyUtil.getInt(PROP_TARGET_RECORDS, 4);
        level = resourceLeakDetector$Level2;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)resourceLeakDetector$Level2.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_TARGET_RECORDS, (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(EmptyArrays.EMPTY_STRINGS);
    }
}

