/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeak;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetector$LeakEntry;
import io.netty.util.ResourceLeakDetector$Record;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class ResourceLeakDetector$DefaultResourceLeak<T>
extends WeakReference<Object>
implements ResourceLeak,
ResourceLeakTracker<T> {
    private static final AtomicReferenceFieldUpdater<ResourceLeakDetector$DefaultResourceLeak<?>, ResourceLeakDetector$Record> headUpdater;
    private static final AtomicIntegerFieldUpdater<ResourceLeakDetector$DefaultResourceLeak<?>> droppedRecordsUpdater;
    private volatile ResourceLeakDetector$Record head;
    private volatile int droppedRecords;
    private final ConcurrentMap<ResourceLeakDetector$DefaultResourceLeak<?>, ResourceLeakDetector$LeakEntry> allLeaks;
    private final int trackedHash;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResourceLeakDetector$DefaultResourceLeak(Object object, ReferenceQueue<Object> referenceQueue, ConcurrentMap<ResourceLeakDetector$DefaultResourceLeak<?>, ResourceLeakDetector$LeakEntry> concurrentMap) {
        super(object, referenceQueue);
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        this.trackedHash = System.identityHashCode(object);
        concurrentMap.put(this, ResourceLeakDetector$LeakEntry.INSTANCE);
        headUpdater.set(this, new ResourceLeakDetector$Record(ResourceLeakDetector$Record.access$100()));
        this.allLeaks = concurrentMap;
    }

    @Override
    public void record() {
        this.record0(null);
    }

    @Override
    public void record(Object object) {
        this.record0(object);
    }

    private void record0(Object object) {
        if (ResourceLeakDetector.access$200() > 0) {
            boolean bl2;
            ResourceLeakDetector$Record resourceLeakDetector$Record;
            ResourceLeakDetector$Record resourceLeakDetector$Record2;
            ResourceLeakDetector$Record resourceLeakDetector$Record3;
            do {
                resourceLeakDetector$Record = resourceLeakDetector$Record3 = headUpdater.get(this);
                if (resourceLeakDetector$Record3 == null) {
                    return;
                }
                int n2 = ResourceLeakDetector$Record.access$300(resourceLeakDetector$Record3) + 1;
                if (n2 >= ResourceLeakDetector.access$200()) {
                    int n3 = Math.min(n2 - ResourceLeakDetector.access$200(), 30);
                    bl2 = PlatformDependent.threadLocalRandom().nextInt(1 << n3) != 0;
                    if (!bl2) continue;
                    resourceLeakDetector$Record = ResourceLeakDetector$Record.access$400(resourceLeakDetector$Record3);
                    continue;
                }
                bl2 = false;
            } while (!headUpdater.compareAndSet(this, resourceLeakDetector$Record3, resourceLeakDetector$Record2 = object != null ? new ResourceLeakDetector$Record(resourceLeakDetector$Record, object) : new ResourceLeakDetector$Record(resourceLeakDetector$Record)));
            if (bl2) {
                droppedRecordsUpdater.incrementAndGet(this);
            }
        }
    }

    boolean dispose() {
        this.clear();
        return this.allLeaks.remove(this, ResourceLeakDetector$LeakEntry.INSTANCE);
    }

    @Override
    public boolean close() {
        if (this.allLeaks.remove(this, ResourceLeakDetector$LeakEntry.INSTANCE)) {
            this.clear();
            headUpdater.set(this, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean close(T t2) {
        if (!$assertionsDisabled && this.trackedHash != System.identityHashCode(t2)) {
            throw new AssertionError();
        }
        return this.close() && t2 != null;
    }

    public String toString() {
        ResourceLeakDetector$Record resourceLeakDetector$Record = headUpdater.getAndSet(this, null);
        if (resourceLeakDetector$Record == null) {
            return "";
        }
        int n2 = droppedRecordsUpdater.get(this);
        int n3 = 0;
        int n4 = ResourceLeakDetector$Record.access$300(resourceLeakDetector$Record) + 1;
        StringBuilder stringBuilder = new StringBuilder(n4 * 2048).append(StringUtil.NEWLINE);
        stringBuilder.append("Recent access records: ").append(StringUtil.NEWLINE);
        int n5 = 1;
        HashSet<String> hashSet = new HashSet<String>(n4);
        while (resourceLeakDetector$Record != ResourceLeakDetector$Record.access$100()) {
            String string = resourceLeakDetector$Record.toString();
            if (hashSet.add(string)) {
                if (ResourceLeakDetector$Record.access$400(resourceLeakDetector$Record) == ResourceLeakDetector$Record.access$100()) {
                    stringBuilder.append("Created at:").append(StringUtil.NEWLINE).append(string);
                } else {
                    stringBuilder.append('#').append(n5++).append(':').append(StringUtil.NEWLINE).append(string);
                }
            } else {
                ++n3;
            }
            resourceLeakDetector$Record = ResourceLeakDetector$Record.access$400(resourceLeakDetector$Record);
        }
        if (n3 > 0) {
            stringBuilder.append(": ").append(n2).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
        }
        if (n2 > 0) {
            stringBuilder.append(": ").append(n2).append(" leak records were discarded because the leak record count is targeted to ").append(ResourceLeakDetector.access$200()).append(". Use system property ").append("io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
        }
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    static {
        $assertionsDisabled = !ResourceLeakDetector.class.desiredAssertionStatus();
        headUpdater = AtomicReferenceFieldUpdater.newUpdater(ResourceLeakDetector$DefaultResourceLeak.class, ResourceLeakDetector$Record.class, "head");
        droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(ResourceLeakDetector$DefaultResourceLeak.class, "droppedRecords");
    }
}

