/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ReferenceCountUtil$ReleasingTask;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain();
        }
        return t2;
    }

    public static <T> T retain(T t2, int n2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain(n2);
        }
        return t2;
    }

    public static <T> T touch(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).touch();
        }
        return t2;
    }

    public static <T> T touch(T t2, Object object) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).touch(object);
        }
        return t2;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static boolean release(Object object, int n2) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release(n2);
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
        }
    }

    public static void safeRelease(Object object, int n2) {
        block2: {
            try {
                ReferenceCountUtil.release(object, n2);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to release a message: {} (decrement: {})", object, n2, throwable);
            }
        }
    }

    @Deprecated
    public static <T> T releaseLater(T t2) {
        return ReferenceCountUtil.releaseLater(t2, 1);
    }

    @Deprecated
    public static <T> T releaseLater(T t2, int n2) {
        if (t2 instanceof ReferenceCounted) {
            ThreadDeathWatcher.watch(Thread.currentThread(), new ReferenceCountUtil$ReleasingTask((ReferenceCounted)t2, n2));
        }
        return t2;
    }

    public static int refCnt(Object object) {
        return object instanceof ReferenceCounted ? ((ReferenceCounted)object).refCnt() : -1;
    }

    private ReferenceCountUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }
}

