/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.SuppressForbidden;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Locale;

class NettyRuntime$AvailableProcessorsHolder {
    private int availableProcessors;

    NettyRuntime$AvailableProcessorsHolder() {
    }

    synchronized void setAvailableProcessors(int n2) {
        ObjectUtil.checkPositive(n2, "availableProcessors");
        if (this.availableProcessors != 0) {
            String string = String.format(Locale.ROOT, "availableProcessors is already set to [%d], rejecting [%d]", this.availableProcessors, n2);
            throw new IllegalStateException(string);
        }
        this.availableProcessors = n2;
    }

    @SuppressForbidden(reason="to obtain default number of available processors")
    synchronized int availableProcessors() {
        if (this.availableProcessors == 0) {
            int n2 = SystemPropertyUtil.getInt("io.netty.availableProcessors", Runtime.getRuntime().availableProcessors());
            this.setAvailableProcessors(n2);
        }
        return this.availableProcessors;
    }
}

