/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.NetUtil$1;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    /*
     * Exception decompiling
     */
    private static Integer sysctlGetInt(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isIpV4StackPreferred() {
        return IPV4_PREFERRED;
    }

    public static boolean isIpV6AddressesPreferred() {
        return IPV6_ADDRESSES_PREFERRED;
    }

    public static byte[] createByteArrayFromIpAddressString(String string) {
        if (NetUtil.isValidIpV4Address(string)) {
            return NetUtil.validIpV4ToBytes(string);
        }
        if (NetUtil.isValidIpV6Address(string)) {
            int n2;
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n2 = string.indexOf(37)) >= 0) {
                string = string.substring(0, n2);
            }
            return NetUtil.getIPv6ByName(string, true);
        }
        return null;
    }

    private static int decimalDigit(String string, int n2) {
        return string.charAt(n2) - 48;
    }

    private static byte ipv4WordToByte(String string, int n2, int n3) {
        int n4 = NetUtil.decimalDigit(string, n2);
        if (++n2 == n3) {
            return (byte)n4;
        }
        n4 = n4 * 10 + NetUtil.decimalDigit(string, n2);
        if (++n2 == n3) {
            return (byte)n4;
        }
        return (byte)(n4 * 10 + NetUtil.decimalDigit(string, n2));
    }

    static byte[] validIpV4ToBytes(String string) {
        byte[] byArray = new byte[4];
        int n2 = string.indexOf(46, 1);
        byArray[0] = NetUtil.ipv4WordToByte(string, 0, n2);
        int n3 = n2 + 1;
        n2 = string.indexOf(46, n2 + 2);
        byArray[1] = NetUtil.ipv4WordToByte(string, n3, n2);
        int n4 = n2 + 1;
        n2 = string.indexOf(46, n2 + 2);
        byArray[2] = NetUtil.ipv4WordToByte(string, n4, n2);
        byArray[3] = NetUtil.ipv4WordToByte(string, n2 + 1, string.length());
        return byArray;
    }

    public static String intToIpAddress(int n2) {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(n2 >> 24 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n2 >> 16 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n2 >> 8 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n2 & 0xFF);
        return stringBuilder.toString();
    }

    public static String bytesToIpAddress(byte[] byArray) {
        return NetUtil.bytesToIpAddress(byArray, 0, byArray.length);
    }

    public static String bytesToIpAddress(byte[] byArray, int n2, int n3) {
        switch (n3) {
            case 4: {
                return new StringBuilder(15).append(byArray[n2] & 0xFF).append('.').append(byArray[n2 + 1] & 0xFF).append('.').append(byArray[n2 + 2] & 0xFF).append('.').append(byArray[n2 + 3] & 0xFF).toString();
            }
            case 16: {
                return NetUtil.toAddressString(byArray, n2, false);
            }
        }
        throw new IllegalArgumentException("length: " + n3 + " (expected: 4 or 16)");
    }

    public static boolean isValidIpV6Address(String string) {
        return NetUtil.isValidIpV6Address((CharSequence)string);
    }

    public static boolean isValidIpV6Address(CharSequence charSequence) {
        int n2;
        int n3;
        int n4;
        int n5 = charSequence.length();
        if (n5 < 2) {
            return false;
        }
        char c2 = charSequence.charAt(0);
        if (c2 == '[') {
            if (charSequence.charAt(--n5) != ']') {
                return false;
            }
            n4 = 1;
            c2 = charSequence.charAt(1);
        } else {
            n4 = 0;
        }
        if (c2 == ':') {
            if (charSequence.charAt(n4 + 1) != ':') {
                return false;
            }
            n3 = 2;
            n2 = n4;
            n4 += 2;
        } else {
            n3 = 0;
            n2 = -1;
        }
        int n6 = 0;
        block5: for (int i2 = n4; i2 < n5; ++i2) {
            c2 = charSequence.charAt(i2);
            if (NetUtil.isValidHexChar(c2)) {
                if (n6 < 4) {
                    ++n6;
                    continue;
                }
                return false;
            }
            switch (c2) {
                case ':': {
                    if (n3 > 7) {
                        return false;
                    }
                    if (charSequence.charAt(i2 - 1) == ':') {
                        if (n2 >= 0) {
                            return false;
                        }
                        n2 = i2 - 1;
                    } else {
                        n6 = 0;
                    }
                    ++n3;
                    continue block5;
                }
                case '.': {
                    int n7;
                    if (n2 < 0 && n3 != 6 || n3 == 7 && n2 >= n4 || n3 > 7) {
                        return false;
                    }
                    int n8 = i2 - n6;
                    int n9 = n8 - 2;
                    if (NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9))) {
                        if (!(NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9 - 1)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9 - 2)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n9 - 3)))) {
                            return false;
                        }
                        n9 -= 5;
                    }
                    while (n9 >= n4) {
                        n7 = charSequence.charAt(n9);
                        if (n7 != 48 && n7 != 58) {
                            return false;
                        }
                        --n9;
                    }
                    n7 = AsciiString.indexOf(charSequence, '%', n8 + 7);
                    if (n7 < 0) {
                        n7 = n5;
                    }
                    return NetUtil.isValidIpV4Address(charSequence, n8, n7);
                }
                case '%': {
                    n5 = i2;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (n2 < 0) {
            return n3 == 7 && n6 > 0;
        }
        return n2 + 2 == n5 || n6 > 0 && (n3 < 8 || n2 <= n4);
    }

    private static boolean isValidIpV4Word(CharSequence charSequence, int n2, int n3) {
        char c2;
        int n4 = n3 - n2;
        if (n4 < 1 || n4 > 3 || (c2 = charSequence.charAt(n2)) < '0') {
            return false;
        }
        if (n4 == 3) {
            char c3;
            char c4 = charSequence.charAt(n2 + 1);
            return c4 >= '0' && (c3 = charSequence.charAt(n2 + 2)) >= '0' && (c2 <= '1' && c4 <= '9' && c3 <= '9' || c2 == '2' && c4 <= '5' && (c3 <= '5' || c4 < '5' && c3 <= '9'));
        }
        return c2 <= '9' && (n4 == 1 || NetUtil.isValidNumericChar(charSequence.charAt(n2 + 1)));
    }

    private static boolean isValidHexChar(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean isValidNumericChar(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c2) {
        return c2 == 'f' || c2 == 'F';
    }

    private static boolean isValidIPv4MappedSeparators(byte by2, byte by3, boolean bl2) {
        return by2 == by3 && (by2 == 0 || !bl2 && by3 == -1);
    }

    private static boolean isValidIPv4Mapped(byte[] byArray, int n2, int n3, int n4) {
        boolean bl2 = n3 + n4 >= 14;
        return n2 <= 12 && n2 >= 2 && (!bl2 || n3 < 12) && NetUtil.isValidIPv4MappedSeparators(byArray[n2 - 1], byArray[n2 - 2], bl2) && PlatformDependent.isZero(byArray, 0, n2 - 3);
    }

    public static boolean isValidIpV4Address(CharSequence charSequence) {
        return NetUtil.isValidIpV4Address(charSequence, 0, charSequence.length());
    }

    public static boolean isValidIpV4Address(String string) {
        return NetUtil.isValidIpV4Address(string, 0, string.length());
    }

    private static boolean isValidIpV4Address(CharSequence charSequence, int n2, int n3) {
        return charSequence instanceof String ? NetUtil.isValidIpV4Address((String)charSequence, n2, n3) : (charSequence instanceof AsciiString ? NetUtil.isValidIpV4Address((AsciiString)charSequence, n2, n3) : NetUtil.isValidIpV4Address0(charSequence, n2, n3));
    }

    private static boolean isValidIpV4Address(String string, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        return n5 <= 15 && n5 >= 7 && (n4 = string.indexOf(46, n2 + 1)) > 0 && NetUtil.isValidIpV4Word(string, n2, n4) && (n4 = string.indexOf(46, n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n2 - 1, n4) && (n4 = string.indexOf(46, n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n2 - 1, n4) && NetUtil.isValidIpV4Word(string, n4 + 1, n3);
    }

    private static boolean isValidIpV4Address(AsciiString asciiString, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        return n5 <= 15 && n5 >= 7 && (n4 = asciiString.indexOf('.', n2 + 1)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2, n4) && (n4 = asciiString.indexOf('.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2 - 1, n4) && (n4 = asciiString.indexOf('.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n2 - 1, n4) && NetUtil.isValidIpV4Word(asciiString, n4 + 1, n3);
    }

    private static boolean isValidIpV4Address0(CharSequence charSequence, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        return n5 <= 15 && n5 >= 7 && (n4 = AsciiString.indexOf(charSequence, '.', n2 + 1)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2, n4) && (n4 = AsciiString.indexOf(charSequence, '.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2 - 1, n4) && (n4 = AsciiString.indexOf(charSequence, '.', n2 = n4 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n2 - 1, n4) && NetUtil.isValidIpV4Word(charSequence, n4 + 1, n3);
    }

    public static Inet6Address getByName(CharSequence charSequence) {
        return NetUtil.getByName(charSequence, true);
    }

    public static Inet6Address getByName(CharSequence charSequence, boolean bl2) {
        byte[] byArray = NetUtil.getIPv6ByName(charSequence, bl2);
        if (byArray == null) {
            return null;
        }
        try {
            return Inet6Address.getByAddress(null, byArray, -1);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    private static byte[] getIPv6ByName(CharSequence charSequence, boolean bl2) {
        int n2;
        char c2;
        int n3;
        byte[] byArray = new byte[16];
        int n4 = charSequence.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = 0;
        int n11 = 0;
        boolean bl3 = false;
        block4: for (n3 = 0; n3 < n4; ++n3) {
            c2 = charSequence.charAt(n3);
            switch (c2) {
                case ':': {
                    if (n3 - n9 > 4 || n11 > 0 || ++n10 > 8 || n7 + 1 >= byArray.length) {
                        return null;
                    }
                    n8 <<= 4 - (n3 - n9) << 2;
                    if (n6 > 0) {
                        n6 -= 2;
                    }
                    byArray[n7++] = (byte)((n8 & 0xF) << 4 | n8 >> 4 & 0xF);
                    byArray[n7++] = (byte)((n8 >> 8 & 0xF) << 4 | n8 >> 12 & 0xF);
                    n2 = n3 + 1;
                    if (n2 < n4 && charSequence.charAt(n2) == ':') {
                        if (n5 != 0 || ++n2 < n4 && charSequence.charAt(n2) == ':') {
                            return null;
                        }
                        bl3 = ++n10 == 2 && n8 == 0;
                        n5 = n7;
                        n6 = byArray.length - n5 - 2;
                        ++n3;
                    }
                    n8 = 0;
                    n9 = -1;
                    continue block4;
                }
                case '.': {
                    n2 = n3 - n9;
                    if (n2 > 3 || n9 < 0 || ++n11 > 3 || n10 > 0 && n7 + n6 < 12 || n3 + 1 >= n4 || n7 >= byArray.length || n11 == 1 && (!bl2 || n7 != 0 && !NetUtil.isValidIPv4Mapped(byArray, n7, n5, n6) || n2 == 3 && (!NetUtil.isValidNumericChar(charSequence.charAt(n3 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n3 - 2)) || !NetUtil.isValidNumericChar(charSequence.charAt(n3 - 3))) || n2 == 2 && (!NetUtil.isValidNumericChar(charSequence.charAt(n3 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n3 - 2))) || n2 == 1 && !NetUtil.isValidNumericChar(charSequence.charAt(n3 - 1)))) {
                        return null;
                    }
                    if ((n9 = ((n8 <<= 3 - n2 << 2) & 0xF) * 100 + (n8 >> 4 & 0xF) * 10 + (n8 >> 8 & 0xF)) < 0 || n9 > 255) {
                        return null;
                    }
                    byArray[n7++] = (byte)n9;
                    n8 = 0;
                    n9 = -1;
                    continue block4;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c2) || n11 > 0 && !NetUtil.isValidNumericChar(c2)) {
                        return null;
                    }
                    if (n9 < 0) {
                        n9 = n3;
                    } else if (n3 - n9 > 4) {
                        return null;
                    }
                    n8 += StringUtil.decodeHexNibble(c2) << (n3 - n9 << 2);
                }
            }
        }
        char c3 = c2 = n5 > 0 ? (char)'\u0001' : '\u0000';
        if (n11 > 0) {
            if (n9 > 0 && n3 - n9 > 3 || n11 != 3 || n7 >= byArray.length) {
                return null;
            }
            if (n10 == 0) {
                n6 = 12;
            } else if (n10 >= 2 && (c2 == '\u0000' && n10 == 6 && charSequence.charAt(0) != ':' || c2 != '\u0000' && n10 < 8 && (charSequence.charAt(0) != ':' || n5 <= 2))) {
                n6 -= 2;
            } else {
                return null;
            }
            n8 <<= 3 - (n3 - n9) << 2;
            n9 = (n8 & 0xF) * 100 + (n8 >> 4 & 0xF) * 10 + (n8 >> 8 & 0xF);
            if (n9 < 0 || n9 > 255) {
                return null;
            }
            byArray[n7++] = (byte)n9;
        } else {
            n2 = n4 - 1;
            if (n9 > 0 && n3 - n9 > 4 || n10 < 2 || c2 == '\u0000' && (n10 + 1 != 8 || charSequence.charAt(0) == ':' || charSequence.charAt(n2) == ':') || c2 != '\u0000' && (n10 > 8 || n10 == 8 && (n5 <= 2 && charSequence.charAt(0) != ':' || n5 >= 14 && charSequence.charAt(n2) != ':')) || n7 + 1 >= byArray.length || n9 < 0 && charSequence.charAt(n2 - 1) != ':' || n5 > 2 && charSequence.charAt(0) == ':') {
                return null;
            }
            if (n9 >= 0 && n3 - n9 <= 4) {
                n8 <<= 4 - (n3 - n9) << 2;
            }
            byArray[n7++] = (byte)((n8 & 0xF) << 4 | n8 >> 4 & 0xF);
            byArray[n7++] = (byte)((n8 >> 8 & 0xF) << 4 | n8 >> 12 & 0xF);
        }
        n3 = n7 + n6;
        if (bl3 || n3 >= byArray.length) {
            if (n3 >= byArray.length) {
                ++n5;
            }
            for (n3 = n7; n3 < byArray.length; ++n3) {
                for (n9 = byArray.length - 1; n9 >= n5; --n9) {
                    byArray[n9] = byArray[n9 - 1];
                }
                byArray[n9] = 0;
                ++n5;
            }
        } else {
            for (n3 = 0; n3 < n6 && (n7 = (n9 = n3 + n5) + n6) < byArray.length; ++n3) {
                byArray[n7] = byArray[n9];
                byArray[n9] = 0;
            }
        }
        if (n11 > 0) {
            byArray[11] = -1;
            byArray[10] = -1;
        }
        return byArray;
    }

    public static String toSocketAddressString(InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder;
        String string = String.valueOf(inetSocketAddress.getPort());
        if (inetSocketAddress.isUnresolved()) {
            String string2;
            stringBuilder = NetUtil.newSocketAddressStringBuilder(string2, string, !NetUtil.isValidIpV6Address(string2 = NetUtil.getHostname(inetSocketAddress)));
        } else {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            String string3 = NetUtil.toAddressString(inetAddress);
            stringBuilder = NetUtil.newSocketAddressStringBuilder(string3, string, inetAddress instanceof Inet4Address);
        }
        return stringBuilder.append(':').append(string).toString();
    }

    public static String toSocketAddressString(String string, int n2) {
        String string2 = String.valueOf(n2);
        return NetUtil.newSocketAddressStringBuilder(string, string2, !NetUtil.isValidIpV6Address(string)).append(':').append(string2).toString();
    }

    private static StringBuilder newSocketAddressStringBuilder(String string, String string2, boolean bl2) {
        int n2 = string.length();
        if (bl2) {
            return new StringBuilder(n2 + 1 + string2.length()).append(string);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 + 3 + string2.length());
        if (n2 > 1 && string.charAt(0) == '[' && string.charAt(n2 - 1) == ']') {
            return stringBuilder.append(string);
        }
        return stringBuilder.append('[').append(string).append(']');
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl2) {
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress);
        }
        return NetUtil.toAddressString(inetAddress.getAddress(), 0, bl2);
    }

    private static String toAddressString(byte[] byArray, int n2, boolean bl2) {
        int n3;
        int n4;
        int[] nArray = new int[8];
        int n5 = n2 + nArray.length;
        for (n4 = n2; n4 < n5; ++n4) {
            nArray[n4] = (byArray[n4 << 1] & 0xFF) << 8 | byArray[(n4 << 1) + 1] & 0xFF;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] == 0) {
                if (n6 >= 0) continue;
                n6 = n4;
                continue;
            }
            if (n6 < 0) continue;
            n3 = n4 - n6;
            if (n3 > n8) {
                n7 = n6;
                n8 = n3;
            }
            n6 = -1;
        }
        if (n6 >= 0 && (n3 = n4 - n6) > n8) {
            n7 = n6;
            n8 = n3;
        }
        if (n8 == 1) {
            n8 = 0;
            n7 = -1;
        }
        int n9 = n7 + n8;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n9 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (n4 = 1; n4 < nArray.length; ++n4) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[n4]));
            }
        } else {
            boolean bl3;
            if (NetUtil.inRangeEndExclusive(0, n7, n9)) {
                stringBuilder.append("::");
                bl3 = bl2 && n9 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl3 = false;
            }
            for (n4 = 1; n4 < nArray.length; ++n4) {
                if (!NetUtil.inRangeEndExclusive(n4, n7, n9)) {
                    if (!NetUtil.inRangeEndExclusive(n4 - 1, n7, n9)) {
                        if (!bl3 || n4 == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl3 && n4 > 5) {
                        stringBuilder.append(nArray[n4] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[n4] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[n4]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(n4 - 1, n7, n9)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    public static String getHostname(InetSocketAddress inetSocketAddress) {
        return PlatformDependent.javaVersion() >= 7 ? inetSocketAddress.getHostString() : inetSocketAddress.getHostName();
    }

    private static boolean inRangeEndExclusive(int n2, int n3, int n4) {
        return n2 >= n3 && n2 < n4;
    }

    private NetUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static /* synthetic */ Integer access$100(String string) {
        return NetUtil.sysctlGetInt(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Enumeration<InetAddress> enumeration;
        Object object;
        Object object2;
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        IPV6_ADDRESSES_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv6Addresses", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", (Object)IPV6_ADDRESSES_PREFERRED);
        byte[] byArray = new byte[]{127, 0, 0, 1};
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        LOCALHOST4 = inet4Address;
        Inet6Address inet6Address = null;
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress("localhost", byArray2);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        LOCALHOST6 = inet6Address;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            if (object2 != null) {
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (!SocketUtils.addressesFromNetworkInterface((NetworkInterface)object).hasMoreElements()) continue;
                    arrayList.add((NetworkInterface)object);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        object2 = null;
        object = null;
        block14: for (NetworkInterface networkInterface : arrayList) {
            enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object2 = networkInterface;
                object = inetAddress;
                break block14;
            }
        }
        if (object2 == null) {
            try {
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.isLoopback() || !(enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface)).hasMoreElements()) continue;
                    object2 = networkInterface;
                    object = enumeration.nextElement();
                    break;
                }
                if (object2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object2).getName(), ((NetworkInterface)object2).getDisplayName(), ((InetAddress)object).getHostAddress());
        } else if (object == null) {
            try {
                if (NetworkInterface.getByInetAddress(LOCALHOST6) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)inet6Address);
                    object = inet6Address;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
        }
        LOOPBACK_IF = object2;
        LOCALHOST = object;
        SOMAXCONN = AccessController.doPrivileged(new NetUtil$1());
    }
}

