/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.NetUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.PrivilegedAction;

final class NetUtil$1
implements PrivilegedAction<Integer> {
    NetUtil$1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer run() {
        int n2 = PlatformDependent.isWindows() ? 200 : 128;
        File file = new File("/proc/sys/net/core/somaxconn");
        BufferedReader bufferedReader = null;
        try {
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                n2 = Integer.parseInt(bufferedReader.readLine());
                if (NetUtil.access$000().isDebugEnabled()) {
                    NetUtil.access$000().debug("{}: {}", (Object)file, (Object)n2);
                }
            } else {
                Integer n3 = null;
                if (SystemPropertyUtil.getBoolean("io.netty.net.somaxconn.trySysctl", false)) {
                    n3 = NetUtil.access$100("kern.ipc.somaxconn");
                    if (n3 == null) {
                        n3 = NetUtil.access$100("kern.ipc.soacceptqueue");
                        if (n3 != null) {
                            n2 = n3;
                        }
                    } else {
                        n2 = n3;
                    }
                }
                if (n3 == null) {
                    NetUtil.access$000().debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)n2);
                }
            }
        }
        catch (Exception exception) {
            NetUtil.access$000().debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, n2, exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return n2;
    }
}

