/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainNameMapping;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class DomainNameMappingBuilder$ImmutableDomainNameMapping<V>
extends DomainNameMapping<V> {
    private static final String REPR_HEADER = "ImmutableDomainNameMapping(default: ";
    private static final String REPR_MAP_OPENING = ", map: {";
    private static final String REPR_MAP_CLOSING = "})";
    private static final int REPR_CONST_PART_LENGTH = "ImmutableDomainNameMapping(default: ".length() + ", map: {".length() + "})".length();
    private final String[] domainNamePatterns;
    private final V[] values;
    private final Map<String, V> map;

    private DomainNameMappingBuilder$ImmutableDomainNameMapping(V v2, Map<String, V> map) {
        super(null, v2);
        Set<Map.Entry<String, V>> set = map.entrySet();
        int n2 = set.size();
        this.domainNamePatterns = new String[n2];
        this.values = new Object[n2];
        LinkedHashMap<String, V> linkedHashMap = new LinkedHashMap<String, V>(map.size());
        int n3 = 0;
        for (Map.Entry<String, V> entry : set) {
            String string = DomainNameMappingBuilder$ImmutableDomainNameMapping.normalizeHostname(entry.getKey());
            V v3 = entry.getValue();
            this.domainNamePatterns[n3] = string;
            this.values[n3] = v3;
            linkedHashMap.put(string, v3);
            ++n3;
        }
        this.map = Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    @Deprecated
    public DomainNameMapping<V> add(String string, V v2) {
        throw new UnsupportedOperationException("Immutable DomainNameMapping does not support modification after initial creation");
    }

    @Override
    public V map(String string) {
        if (string != null) {
            string = DomainNameMappingBuilder$ImmutableDomainNameMapping.normalizeHostname(string);
            int n2 = this.domainNamePatterns.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!DomainNameMappingBuilder$ImmutableDomainNameMapping.matches(this.domainNamePatterns[i2], string)) continue;
                return this.values[i2];
            }
        }
        return (V)this.defaultValue;
    }

    @Override
    public Map<String, V> asMap() {
        return this.map;
    }

    @Override
    public String toString() {
        String string = this.defaultValue.toString();
        int n2 = this.domainNamePatterns.length;
        if (n2 == 0) {
            return REPR_HEADER + string + REPR_MAP_OPENING + REPR_MAP_CLOSING;
        }
        String string2 = this.domainNamePatterns[0];
        String string3 = this.values[0].toString();
        int n3 = string2.length() + string3.length() + 3;
        int n4 = DomainNameMappingBuilder$ImmutableDomainNameMapping.estimateBufferSize(string.length(), n2, n3);
        StringBuilder stringBuilder = new StringBuilder(n4).append(REPR_HEADER).append(string).append(REPR_MAP_OPENING);
        DomainNameMappingBuilder$ImmutableDomainNameMapping.appendMapping(stringBuilder, string2, string3);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(", ");
            this.appendMapping(stringBuilder, i2);
        }
        return stringBuilder.append(REPR_MAP_CLOSING).toString();
    }

    private static int estimateBufferSize(int n2, int n3, int n4) {
        return REPR_CONST_PART_LENGTH + n2 + (int)((double)(n4 * n3) * 1.1);
    }

    private StringBuilder appendMapping(StringBuilder stringBuilder, int n2) {
        return DomainNameMappingBuilder$ImmutableDomainNameMapping.appendMapping(stringBuilder, this.domainNamePatterns[n2], this.values[n2].toString());
    }

    private static StringBuilder appendMapping(StringBuilder stringBuilder, String string, String string2) {
        return stringBuilder.append(string).append('=').append(string2);
    }
}

