/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString$1;
import io.netty.util.AsciiString$2;
import io.netty.util.AsciiString$AsciiCaseInsensitiveCharEqualityComparator;
import io.netty.util.AsciiString$CharEqualityComparator;
import io.netty.util.AsciiString$DefaultCharEqualityComparator;
import io.netty.util.AsciiString$GeneralCaseInsensitiveCharEqualityComparator;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final int INDEX_NOT_FOUND = -1;
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new AsciiString$1();
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new AsciiString$2();

    public AsciiString(byte[] byArray) {
        this(byArray, true);
    }

    public AsciiString(byte[] byArray, boolean bl2) {
        this(byArray, 0, byArray.length, bl2);
    }

    public AsciiString(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.value = Arrays.copyOfRange(byArray, n2, n2 + n3);
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(n2, n3, byArray.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + byArray.length + ')');
            }
            this.value = byArray;
            this.offset = n2;
        }
        this.length = n3;
    }

    public AsciiString(ByteBuffer byteBuffer) {
        this(byteBuffer, true);
    }

    public AsciiString(ByteBuffer byteBuffer, boolean bl2) {
        this(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), bl2);
    }

    public AsciiString(ByteBuffer byteBuffer, int n2, int n3, boolean bl2) {
        if (MathUtil.isOutOfBounds(n2, n3, byteBuffer.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.capacity(" + byteBuffer.capacity() + ')');
        }
        if (byteBuffer.hasArray()) {
            if (bl2) {
                int n4 = byteBuffer.arrayOffset() + n2;
                this.value = Arrays.copyOfRange(byteBuffer.array(), n4, n4 + n3);
                this.offset = 0;
            } else {
                this.value = byteBuffer.array();
                this.offset = n2;
            }
        } else {
            this.value = new byte[n3];
            int n5 = byteBuffer.position();
            byteBuffer.get(this.value, 0, n3);
            byteBuffer.position(n5);
            this.offset = 0;
        }
        this.length = n3;
    }

    public AsciiString(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public AsciiString(char[] cArray, int n2, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, cArray.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + cArray.length + ')');
        }
        this.value = new byte[n3];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.value[n4] = AsciiString.c2b(cArray[n5]);
            ++n4;
            ++n5;
        }
        this.offset = 0;
        this.length = n3;
    }

    public AsciiString(char[] cArray, Charset charset) {
        this(cArray, charset, 0, cArray.length);
    }

    public AsciiString(char[] cArray, Charset charset, int n2, int n3) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(charsetEncoder.maxBytesPerChar() * (float)n3));
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        int n4 = byteBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(byteBuffer.array(), n4, n4 + byteBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public AsciiString(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public AsciiString(CharSequence charSequence, int n2, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= value.length(" + charSequence.length() + ')');
        }
        this.value = new byte[n3];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.value[n4] = AsciiString.c2b(charSequence.charAt(n5));
            ++n4;
            ++n5;
        }
        this.offset = 0;
        this.length = n3;
    }

    public AsciiString(CharSequence charSequence, Charset charset) {
        this(charSequence, charset, 0, charSequence.length());
    }

    public AsciiString(CharSequence charSequence, Charset charset, int n2, int n3) {
        CharBuffer charBuffer = CharBuffer.wrap(charSequence, n2, n2 + n3);
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(charsetEncoder.maxBytesPerChar() * (float)n3));
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        int n4 = byteBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(byteBuffer.array(), n4, n4 + byteBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public int forEachByte(ByteProcessor byteProcessor) {
        return this.forEachByte0(0, this.length(), byteProcessor);
    }

    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        if (MathUtil.isOutOfBounds(n2, n3, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + n2 + ") <= start + length(" + n3 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(n2, n3, byteProcessor);
    }

    private int forEachByte0(int n2, int n3, ByteProcessor byteProcessor) {
        int n4 = this.offset + n2 + n3;
        for (int i2 = this.offset + n2; i2 < n4; ++i2) {
            if (byteProcessor.process(this.value[i2])) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public int forEachByteDesc(ByteProcessor byteProcessor) {
        return this.forEachByteDesc0(0, this.length(), byteProcessor);
    }

    public int forEachByteDesc(int n2, int n3, ByteProcessor byteProcessor) {
        if (MathUtil.isOutOfBounds(n2, n3, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + n2 + ") <= start + length(" + n3 + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0(n2, n3, byteProcessor);
    }

    private int forEachByteDesc0(int n2, int n3, ByteProcessor byteProcessor) {
        int n4 = this.offset + n2;
        for (int i2 = this.offset + n2 + n3 - 1; i2 >= n4; --i2) {
            if (byteProcessor.process(this.value[i2])) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public byte byteAt(int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new IndexOutOfBoundsException("index: " + n2 + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, n2 + this.offset);
        }
        return this.value[n2 + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public void arrayChanged() {
        this.string = null;
        this.hash = 0;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    public boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int n2, int n3) {
        return Arrays.copyOfRange(this.value, n2 + this.offset, n3 + this.offset);
    }

    public void copy(int n2, byte[] byArray, int n3, int n4) {
        if (MathUtil.isOutOfBounds(n2, n4, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, n2 + this.offset, ObjectUtil.checkNotNull(byArray, "dst"), n3, n4);
    }

    @Override
    public char charAt(int n2) {
        return AsciiString.b2c(this.byteAt(n2));
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(charSequence) >= 0;
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        if (this == charSequence) {
            return 0;
        }
        int n2 = this.length();
        int n3 = charSequence.length();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = this.arrayOffset();
        while (n5 < n4) {
            int n7 = AsciiString.b2c(this.value[n6]) - charSequence.charAt(n5);
            if (n7 != 0) {
                return n7;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public AsciiString concat(CharSequence charSequence) {
        int n2 = this.length();
        int n3 = charSequence.length();
        if (n3 == 0) {
            return this;
        }
        if (charSequence.getClass() == AsciiString.class) {
            AsciiString asciiString = (AsciiString)charSequence;
            if (this.isEmpty()) {
                return asciiString;
            }
            byte[] byArray = new byte[n2 + n3];
            System.arraycopy(this.value, this.arrayOffset(), byArray, 0, n2);
            System.arraycopy(asciiString.value, asciiString.arrayOffset(), byArray, n2, n3);
            return new AsciiString(byArray, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(charSequence);
        }
        byte[] byArray = new byte[n2 + n3];
        System.arraycopy(this.value, this.arrayOffset(), byArray, 0, n2);
        int n4 = n2;
        int n5 = 0;
        while (n4 < byArray.length) {
            byArray[n4] = AsciiString.c2b(charSequence.charAt(n5));
            ++n4;
            ++n5;
        }
        return new AsciiString(byArray, false);
    }

    public boolean endsWith(CharSequence charSequence) {
        int n2 = charSequence.length();
        return this.regionMatches(this.length() - n2, charSequence, 0, n2);
    }

    public boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence.getClass() == AsciiString.class) {
            AsciiString asciiString = (AsciiString)charSequence;
            int n2 = this.arrayOffset();
            int n3 = asciiString.arrayOffset();
            while (n2 < this.length()) {
                if (!AsciiString.equalsIgnoreCase(this.value[n2], asciiString.value[n3])) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        int n4 = this.arrayOffset();
        int n5 = 0;
        while (n4 < this.length()) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[n4]), charSequence.charAt(n5))) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (MathUtil.isOutOfBounds(n2, n4, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + this.length() + ')');
        }
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = n2 + this.arrayOffset();
        while (n5 < n4) {
            cArray[n5] = AsciiString.b2c(this.value[n6]);
            ++n5;
            ++n6;
        }
        return cArray;
    }

    public void copy(int n2, char[] cArray, int n3, int n4) {
        if (cArray == null) {
            throw new NullPointerException("dst");
        }
        if (MathUtil.isOutOfBounds(n2, n4, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + this.length() + ')');
        }
        int n5 = n3 + n4;
        int n6 = n3;
        int n7 = n2 + this.arrayOffset();
        while (n6 < n5) {
            cArray[n6] = AsciiString.b2c(this.value[n7]);
            ++n6;
            ++n7;
        }
    }

    public AsciiString subSequence(int n2) {
        return this.subSequence(n2, this.length());
    }

    @Override
    public AsciiString subSequence(int n2, int n3) {
        return this.subSequence(n2, n3, true);
    }

    public AsciiString subSequence(int n2, int n3, boolean bl2) {
        if (MathUtil.isOutOfBounds(n2, n3 - n2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= end (" + n3 + ") <= length(" + this.length() + ')');
        }
        if (n2 == 0 && n3 == this.length()) {
            return this;
        }
        if (n3 == n2) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, n2 + this.offset, n3 - n2, bl2);
    }

    public int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public int indexOf(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 <= 0) {
            return n2 < this.length ? n2 : this.length;
        }
        if (n3 > this.length - n2) {
            return -1;
        }
        char c2 = charSequence.charAt(0);
        if (c2 > '\u00ff') {
            return -1;
        }
        byte by2 = AsciiString.c2b0(c2);
        int n4 = this.offset + this.length - n3;
        for (int i2 = n2 + this.offset; i2 <= n4; ++i2) {
            if (this.value[i2] != by2) continue;
            int n5 = i2;
            int n6 = 0;
            while (++n6 < n3 && AsciiString.b2c(this.value[++n5]) == charSequence.charAt(n6)) {
            }
            if (n6 != n3) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public int indexOf(char c2, int n2) {
        if (c2 > '\u00ff') {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        byte by2 = AsciiString.c2b0(c2);
        int n3 = this.offset + n2 + this.length;
        for (int i2 = n2 + this.offset; i2 < n3; ++i2) {
            if (this.value[i2] != by2) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence charSequence) {
        return this.lastIndexOf(charSequence, this.length());
    }

    public int lastIndexOf(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 <= 0) {
            return n2 < this.length ? n2 : this.length;
        }
        if (n3 > this.length - n2) {
            return -1;
        }
        char c2 = charSequence.charAt(0);
        if (c2 > '\u00ff') {
            return -1;
        }
        byte by2 = AsciiString.c2b0(c2);
        int n4 = this.offset + n2;
        for (int i2 = this.offset + this.length - n3; i2 >= n4; --i2) {
            if (this.value[i2] != by2) continue;
            int n5 = i2;
            int n6 = 0;
            while (++n6 < n3 && AsciiString.b2c(this.value[++n5]) == charSequence.charAt(n6)) {
            }
            if (n6 != n3) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public boolean regionMatches(int n2, CharSequence charSequence, int n3, int n4) {
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        if (n3 < 0 || charSequence.length() - n3 < n4) {
            return false;
        }
        int n5 = this.length();
        if (n2 < 0 || n5 - n2 < n4) {
            return false;
        }
        if (n4 <= 0) {
            return true;
        }
        int n6 = n3 + n4;
        int n7 = n3;
        int n8 = n2 + this.arrayOffset();
        while (n7 < n6) {
            if (AsciiString.b2c(this.value[n8]) != charSequence.charAt(n7)) {
                return false;
            }
            ++n7;
            ++n8;
        }
        return true;
    }

    public boolean regionMatches(boolean bl2, int n2, CharSequence charSequence, int n3, int n4) {
        if (!bl2) {
            return this.regionMatches(n2, charSequence, n3, n4);
        }
        if (charSequence == null) {
            throw new NullPointerException("string");
        }
        int n5 = this.length();
        if (n2 < 0 || n4 > n5 - n2) {
            return false;
        }
        if (n3 < 0 || n4 > charSequence.length() - n3) {
            return false;
        }
        int n6 = (n2 += this.arrayOffset()) + n4;
        while (n2 < n6) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[n2++]), charSequence.charAt(n3++))) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char c2, char c3) {
        if (c2 > '\u00ff') {
            return this;
        }
        byte by2 = AsciiString.c2b0(c2);
        byte by3 = AsciiString.c2b(c3);
        int n2 = this.offset + this.length;
        for (int i2 = this.offset; i2 < n2; ++i2) {
            if (this.value[i2] != by2) continue;
            byte[] byArray = new byte[this.length()];
            System.arraycopy(this.value, this.offset, byArray, 0, i2 - this.offset);
            byArray[i2 - this.offset] = by3;
            ++i2;
            while (i2 < n2) {
                byte by4 = this.value[i2];
                byArray[i2 - this.offset] = by4 != by2 ? by4 : by3;
                ++i2;
            }
            return new AsciiString(byArray, false);
        }
        return this;
    }

    public boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public boolean startsWith(CharSequence charSequence, int n2) {
        return this.regionMatches(n2, charSequence, 0, charSequence.length());
    }

    public AsciiString toLowerCase() {
        int n2;
        boolean bl2 = true;
        int n3 = this.length() + this.arrayOffset();
        for (n2 = this.arrayOffset(); n2 < n3; ++n2) {
            byte by2 = this.value[n2];
            if (by2 < 65 || by2 > 90) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return this;
        }
        byte[] byArray = new byte[this.length()];
        n2 = 0;
        int n4 = this.arrayOffset();
        while (n2 < byArray.length) {
            byArray[n2] = AsciiString.toLowerCase(this.value[n4]);
            ++n2;
            ++n4;
        }
        return new AsciiString(byArray, false);
    }

    public AsciiString toUpperCase() {
        int n2;
        boolean bl2 = true;
        int n3 = this.length() + this.arrayOffset();
        for (n2 = this.arrayOffset(); n2 < n3; ++n2) {
            byte by2 = this.value[n2];
            if (by2 < 97 || by2 > 122) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return this;
        }
        byte[] byArray = new byte[this.length()];
        n2 = 0;
        int n4 = this.arrayOffset();
        while (n2 < byArray.length) {
            byArray[n2] = AsciiString.toUpperCase(this.value[n4]);
            ++n2;
            ++n4;
        }
        return new AsciiString(byArray, false);
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n2;
        int n3;
        if (charSequence.getClass() == AsciiString.class) {
            return ((AsciiString)charSequence).trim();
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int n4 = n3 = charSequence.length() - 1;
        for (n2 = 0; n2 <= n4 && charSequence.charAt(n2) <= ' '; ++n2) {
        }
        while (n4 >= n2 && charSequence.charAt(n4) <= ' ') {
            --n4;
        }
        if (n2 == 0 && n4 == n3) {
            return charSequence;
        }
        return charSequence.subSequence(n2, n4);
    }

    public AsciiString trim() {
        int n2;
        int n3;
        int n4 = n3 = this.arrayOffset() + this.length() - 1;
        for (n2 = this.arrayOffset(); n2 <= n4 && this.value[n2] <= 32; ++n2) {
        }
        while (n4 >= n2 && this.value[n4] <= 32) {
            --n4;
        }
        if (n2 == 0 && n4 == n3) {
            return this;
        }
        return new AsciiString(this.value, n2, n4 - n2 + 1, false);
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        if (charSequence.getClass() == AsciiString.class) {
            return this.equals(charSequence);
        }
        int n2 = this.arrayOffset();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (AsciiString.b2c(this.value[n2]) != charSequence.charAt(i2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public AsciiString[] split(String string, int n2) {
        return AsciiString.toAsciiStringArray(Pattern.compile(string).split(this, n2));
    }

    public AsciiString[] split(char c2) {
        int n2;
        ArrayList<AsciiString> arrayList = InternalThreadLocalMap.get().arrayList();
        int n3 = 0;
        int n4 = this.length();
        for (n2 = n3; n2 < n4; ++n2) {
            if (this.charAt(n2) != c2) continue;
            if (n3 == n2) {
                arrayList.add(EMPTY_STRING);
            } else {
                arrayList.add(new AsciiString(this.value, n3 + this.arrayOffset(), n2 - n3, false));
            }
            n3 = n2 + 1;
        }
        if (n3 == 0) {
            arrayList.add(this);
        } else if (n3 != n4) {
            arrayList.add(new AsciiString(this.value, n3 + this.arrayOffset(), n4 - n3, false));
        } else {
            for (n2 = arrayList.size() - 1; n2 >= 0 && ((AsciiString)arrayList.get(n2)).isEmpty(); --n2) {
                arrayList.remove(n2);
            }
        }
        return arrayList.toArray(new AsciiString[arrayList.size()]);
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            this.hash = n2 = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != AsciiString.class) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AsciiString asciiString = (AsciiString)object;
        return this.length() == asciiString.length() && this.hashCode() == asciiString.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), asciiString.array(), asciiString.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String string = this.string;
        if (string == null) {
            this.string = string = this.toString(0);
        }
        return string;
    }

    public String toString(int n2) {
        return this.toString(n2, this.length());
    }

    public String toString(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(n2, n4, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + this.length() + ')');
        }
        String string = new String(this.value, 0, n2 + this.offset, n4);
        return string;
    }

    public boolean parseBoolean() {
        return this.length >= 1 && this.value[this.offset] != 0;
    }

    public char parseChar() {
        return this.parseChar(0);
    }

    public char parseChar(int n2) {
        if (n2 + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + n2 + " would go out of bounds.");
        }
        int n3 = n2 + this.offset;
        return (char)(AsciiString.b2c(this.value[n3]) << 8 | AsciiString.b2c(this.value[n3 + 1]));
    }

    public short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    public short parseShort(int n2) {
        return this.parseShort(0, this.length(), n2);
    }

    public short parseShort(int n2, int n3) {
        return this.parseShort(n2, n3, 10);
    }

    public short parseShort(int n2, int n3, int n4) {
        int n5 = this.parseInt(n2, n3, n4);
        short s2 = (short)n5;
        if (s2 != n5) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return s2;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int n2) {
        return this.parseInt(0, this.length(), n2);
    }

    public int parseInt(int n2, int n3) {
        return this.parseInt(n2, n3, 10);
    }

    public int parseInt(int n2, int n3, int n4) {
        boolean bl2;
        if (n4 < 2 || n4 > 36) {
            throw new NumberFormatException();
        }
        if (n2 == n3) {
            throw new NumberFormatException();
        }
        int n5 = n2;
        boolean bl3 = bl2 = this.byteAt(n5) == 45;
        if (bl2 && ++n5 == n3) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return this.parseInt(n5, n3, n4, bl2);
    }

    private int parseInt(int n2, int n3, int n4, boolean bl2) {
        int n5 = Integer.MIN_VALUE / n4;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            int n8;
            if ((n8 = Character.digit((char)(this.value[n7++ + this.offset] & 0xFF), n4)) == -1) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            if (n5 > n6) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            int n9 = n6 * n4 - n8;
            if (n9 > n6) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            n6 = n9;
        }
        if (!bl2 && (n6 = -n6) < 0) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return n6;
    }

    public long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    public long parseLong(int n2) {
        return this.parseLong(0, this.length(), n2);
    }

    public long parseLong(int n2, int n3) {
        return this.parseLong(n2, n3, 10);
    }

    public long parseLong(int n2, int n3, int n4) {
        boolean bl2;
        if (n4 < 2 || n4 > 36) {
            throw new NumberFormatException();
        }
        if (n2 == n3) {
            throw new NumberFormatException();
        }
        int n5 = n2;
        boolean bl3 = bl2 = this.byteAt(n5) == 45;
        if (bl2 && ++n5 == n3) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return this.parseLong(n5, n3, n4, bl2);
    }

    private long parseLong(int n2, int n3, int n4, boolean bl2) {
        long l2 = Long.MIN_VALUE / (long)n4;
        long l3 = 0L;
        int n5 = n2;
        while (n5 < n3) {
            int n6;
            if ((n6 = Character.digit((char)(this.value[n5++ + this.offset] & 0xFF), n4)) == -1) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            if (l2 > l3) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            long l4 = l3 * (long)n4 - (long)n6;
            if (l4 > l3) {
                throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
            }
            l3 = l4;
        }
        if (!bl2 && (l3 = -l3) < 0L) {
            throw new NumberFormatException(this.subSequence(n2, n3, false).toString());
        }
        return l3;
    }

    public float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    public float parseFloat(int n2, int n3) {
        return Float.parseFloat(this.toString(n2, n3));
    }

    public double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    public double parseDouble(int n2, int n3) {
        return Double.parseDouble(this.toString(n2, n3));
    }

    public static AsciiString of(CharSequence charSequence) {
        return charSequence.getClass() == AsciiString.class ? (AsciiString)charSequence : new AsciiString(charSequence);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        asciiString.string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        if (charSequence.getClass() == AsciiString.class) {
            return charSequence.hashCode();
        }
        return PlatformDependent.hashCodeAscii(charSequence);
    }

    public static boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return AsciiString.contains(charSequence, charSequence2, AsciiString$DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean containsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return AsciiString.contains(charSequence, charSequence2, AsciiString$AsciiCaseInsensitiveCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence.getClass() == AsciiString.class) {
            return ((AsciiString)charSequence).contentEqualsIgnoreCase(charSequence2);
        }
        if (charSequence2.getClass() == AsciiString.class) {
            return ((AsciiString)charSequence2).contentEqualsIgnoreCase(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < charSequence.length()) {
            if (!AsciiString.equalsIgnoreCase(charSequence.charAt(n2), charSequence2.charAt(n3))) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence charSequence) {
        for (CharSequence charSequence2 : collection) {
            if (!AsciiString.contentEqualsIgnoreCase(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> collection, Collection<CharSequence> collection2) {
        for (CharSequence charSequence : collection2) {
            if (AsciiString.containsContentEqualsIgnoreCase(collection, charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence.getClass() == AsciiString.class) {
            return ((AsciiString)charSequence).contentEquals(charSequence2);
        }
        if (charSequence2.getClass() == AsciiString.class) {
            return ((AsciiString)charSequence2).contentEquals(charSequence);
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private static AsciiString[] toAsciiStringArray(String[] stringArray) {
        AsciiString[] asciiStringArray = new AsciiString[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            asciiStringArray[i2] = new AsciiString(stringArray[i2]);
        }
        return asciiStringArray;
    }

    private static boolean contains(CharSequence charSequence, CharSequence charSequence2, AsciiString$CharEqualityComparator asciiString$CharEqualityComparator) {
        if (charSequence == null || charSequence2 == null || charSequence.length() < charSequence2.length()) {
            return false;
        }
        if (charSequence2.length() == 0) {
            return true;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (asciiString$CharEqualityComparator.equals(charSequence2.charAt(n2), charSequence.charAt(i2))) {
                if (++n2 != charSequence2.length()) continue;
                return true;
            }
            if (charSequence.length() - i2 < charSequence2.length()) {
                return false;
            }
            n2 = 0;
        }
        return false;
    }

    private static boolean regionMatchesCharSequences(CharSequence charSequence, int n2, CharSequence charSequence2, int n3, int n4, AsciiString$CharEqualityComparator asciiString$CharEqualityComparator) {
        if (n2 < 0 || n4 > charSequence.length() - n2) {
            return false;
        }
        if (n3 < 0 || n4 > charSequence2.length() - n3) {
            return false;
        }
        int n5 = n2;
        int n6 = n5 + n4;
        int n7 = n3;
        while (n5 < n6) {
            char c2;
            char c3;
            if (asciiString$CharEqualityComparator.equals(c3 = charSequence.charAt(n5++), c2 = charSequence2.charAt(n7++))) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence charSequence, boolean bl2, int n2, CharSequence charSequence2, int n3, int n4) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).regionMatches(bl2, n2, (String)charSequence2, n3, n4);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).regionMatches(bl2, n2, charSequence2, n3, n4);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, n2, charSequence2, n3, n4, bl2 ? AsciiString$GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : AsciiString$DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean regionMatchesAscii(CharSequence charSequence, boolean bl2, int n2, CharSequence charSequence2, int n3, int n4) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (!bl2 && charSequence instanceof String && charSequence2 instanceof String) {
            return ((String)charSequence).regionMatches(false, n2, (String)charSequence2, n3, n4);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).regionMatches(bl2, n2, charSequence2, n3, n4);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, n2, charSequence2, n3, n4, bl2 ? AsciiString$AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : AsciiString$DefaultCharEqualityComparator.INSTANCE);
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = charSequence2.length();
        int n4 = charSequence.length() - n3 + 1;
        if (n2 > n4) {
            return -1;
        }
        if (n3 == 0) {
            return n2;
        }
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!AsciiString.regionMatches(charSequence, true, i2, charSequence2, 0, n3)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseAscii(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = charSequence2.length();
        int n4 = charSequence.length() - n3 + 1;
        if (n2 > n4) {
            return -1;
        }
        if (n3 == 0) {
            return n2;
        }
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!AsciiString.regionMatchesAscii(charSequence, true, i2, charSequence2, 0, n3)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, char c2, int n2) {
        int n3;
        if (charSequence instanceof String) {
            return ((String)charSequence).indexOf(c2, n2);
        }
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).indexOf(c2, n2);
        }
        if (charSequence == null) {
            return -1;
        }
        int n4 = charSequence.length();
        int n5 = n3 = n2 < 0 ? 0 : n2;
        while (n3 < n4) {
            if (charSequence.charAt(n3) == c2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte by2, byte by3) {
        return by2 == by3 || AsciiString.toLowerCase(by2) == AsciiString.toLowerCase(by3);
    }

    private static boolean equalsIgnoreCase(char c2, char c3) {
        return c2 == c3 || AsciiString.toLowerCase(c2) == AsciiString.toLowerCase(c3);
    }

    private static byte toLowerCase(byte by2) {
        return AsciiString.isUpperCase(by2) ? (byte)(by2 + 32) : by2;
    }

    private static char toLowerCase(char c2) {
        return AsciiString.isUpperCase(c2) ? (char)(c2 + 32) : c2;
    }

    private static byte toUpperCase(byte by2) {
        return AsciiString.isLowerCase(by2) ? (byte)(by2 - 32) : by2;
    }

    private static boolean isLowerCase(byte by2) {
        return by2 >= 97 && by2 <= 122;
    }

    public static boolean isUpperCase(byte by2) {
        return by2 >= 65 && by2 <= 90;
    }

    public static boolean isUpperCase(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static byte c2b(char c2) {
        return (byte)(c2 > '\u00ff' ? 63 : (int)c2);
    }

    private static byte c2b0(char c2) {
        return (byte)c2;
    }

    public static char b2c(byte by2) {
        return (char)(by2 & 0xFF);
    }

    static /* synthetic */ boolean access$000(char c2, char c3) {
        return AsciiString.equalsIgnoreCase(c2, c3);
    }
}

