/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCounted
implements ReferenceCounted {
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCounted> refCntUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCounted.class, "refCnt");
    private volatile int refCnt = 1;

    @Override
    public final int refCnt() {
        return this.refCnt;
    }

    protected final void setRefCnt(int n2) {
        refCntUpdater.set(this, n2);
    }

    @Override
    public ReferenceCounted retain() {
        return this.retain0(1);
    }

    @Override
    public ReferenceCounted retain(int n2) {
        return this.retain0(ObjectUtil.checkPositive(n2, "increment"));
    }

    private ReferenceCounted retain0(int n2) {
        int n3 = refCntUpdater.getAndAdd(this, n2);
        if (n3 <= 0 || n3 + n2 < n3) {
            refCntUpdater.getAndAdd(this, -n2);
            throw new IllegalReferenceCountException(n3, n2);
        }
        return this;
    }

    @Override
    public ReferenceCounted touch() {
        return this.touch(null);
    }

    @Override
    public boolean release() {
        return this.release0(1);
    }

    @Override
    public boolean release(int n2) {
        return this.release0(ObjectUtil.checkPositive(n2, "decrement"));
    }

    private boolean release0(int n2) {
        int n3 = refCntUpdater.getAndAdd(this, -n2);
        if (n3 == n2) {
            this.deallocate();
            return true;
        }
        if (n3 < n2 || n3 - n2 > n3) {
            refCntUpdater.getAndAdd(this, n2);
            throw new IllegalReferenceCountException(n3, -n2);
        }
        return false;
    }

    protected abstract void deallocate();
}

