/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Random;

final class ShuffledDnsServerAddressStream
implements DnsServerAddressStream {
    private final InetSocketAddress[] addresses;
    private int i;

    ShuffledDnsServerAddressStream(InetSocketAddress[] inetSocketAddressArray) {
        this.addresses = inetSocketAddressArray;
        this.shuffle();
    }

    private ShuffledDnsServerAddressStream(InetSocketAddress[] inetSocketAddressArray, int n2) {
        this.addresses = inetSocketAddressArray;
        this.i = n2;
    }

    private void shuffle() {
        InetSocketAddress[] inetSocketAddressArray = this.addresses;
        Random random = PlatformDependent.threadLocalRandom();
        for (int i2 = inetSocketAddressArray.length - 1; i2 >= 0; --i2) {
            InetSocketAddress inetSocketAddress = inetSocketAddressArray[i2];
            int n2 = random.nextInt(i2 + 1);
            inetSocketAddressArray[i2] = inetSocketAddressArray[n2];
            inetSocketAddressArray[n2] = inetSocketAddress;
        }
    }

    @Override
    public InetSocketAddress next() {
        int n2 = this.i;
        InetSocketAddress inetSocketAddress = this.addresses[n2];
        if (++n2 < this.addresses.length) {
            this.i = n2;
        } else {
            this.i = 0;
            this.shuffle();
        }
        return inetSocketAddress;
    }

    @Override
    public int size() {
        return this.addresses.length;
    }

    @Override
    public ShuffledDnsServerAddressStream duplicate() {
        return new ShuffledDnsServerAddressStream(this.addresses, this.i);
    }

    public String toString() {
        return SequentialDnsServerAddressStream.toString("shuffled", this.i, this.addresses);
    }
}

