/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DnsServerAddressStream;
import java.net.InetSocketAddress;

final class SequentialDnsServerAddressStream
implements DnsServerAddressStream {
    private final InetSocketAddress[] addresses;
    private int i;

    SequentialDnsServerAddressStream(InetSocketAddress[] inetSocketAddressArray, int n2) {
        this.addresses = inetSocketAddressArray;
        this.i = n2;
    }

    @Override
    public InetSocketAddress next() {
        int n2 = this.i;
        InetSocketAddress inetSocketAddress = this.addresses[n2];
        this.i = ++n2 < this.addresses.length ? n2 : 0;
        return inetSocketAddress;
    }

    @Override
    public int size() {
        return this.addresses.length;
    }

    @Override
    public SequentialDnsServerAddressStream duplicate() {
        return new SequentialDnsServerAddressStream(this.addresses, this.i);
    }

    public String toString() {
        return SequentialDnsServerAddressStream.toString("sequential", this.i, this.addresses);
    }

    static String toString(String string, int n2, InetSocketAddress[] inetSocketAddressArray) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + inetSocketAddressArray.length * 16);
        stringBuilder.append(string).append("(index: ").append(n2);
        stringBuilder.append(", addrs: (");
        for (InetSocketAddress inetSocketAddress : inetSocketAddressArray) {
            stringBuilder.append(inetSocketAddress).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        stringBuilder.append("))");
        return stringBuilder.toString();
    }
}

