/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DefaultDnsServerAddresses;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class RotationalDnsServerAddresses
extends DefaultDnsServerAddresses {
    private static final AtomicIntegerFieldUpdater<RotationalDnsServerAddresses> startIdxUpdater = AtomicIntegerFieldUpdater.newUpdater(RotationalDnsServerAddresses.class, "startIdx");
    private volatile int startIdx;

    RotationalDnsServerAddresses(InetSocketAddress[] inetSocketAddressArray) {
        super("rotational", inetSocketAddressArray);
    }

    @Override
    public DnsServerAddressStream stream() {
        int n2;
        int n3;
        do {
            if ((n2 = (n3 = this.startIdx) + 1) < this.addresses.length) continue;
            n2 = 0;
        } while (!startIdxUpdater.compareAndSet(this, n3, n2));
        return new SequentialDnsServerAddressStream(this.addresses, n3);
    }
}

