/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.InflightNameResolver$1;
import io.netty.resolver.dns.InflightNameResolver$2;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

final class InflightNameResolver<T>
implements NameResolver<T> {
    private final EventExecutor executor;
    private final NameResolver<T> delegate;
    private final ConcurrentMap<String, Promise<T>> resolvesInProgress;
    private final ConcurrentMap<String, Promise<List<T>>> resolveAllsInProgress;

    InflightNameResolver(EventExecutor eventExecutor, NameResolver<T> nameResolver, ConcurrentMap<String, Promise<T>> concurrentMap, ConcurrentMap<String, Promise<List<T>>> concurrentMap2) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
        this.delegate = ObjectUtil.checkNotNull(nameResolver, "delegate");
        this.resolvesInProgress = ObjectUtil.checkNotNull(concurrentMap, "resolvesInProgress");
        this.resolveAllsInProgress = ObjectUtil.checkNotNull(concurrentMap2, "resolveAllsInProgress");
    }

    @Override
    public Future<T> resolve(String string) {
        return this.resolve(string, this.executor.newPromise());
    }

    @Override
    public Future<List<T>> resolveAll(String string) {
        return this.resolveAll(string, this.executor.newPromise());
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Promise<T> resolve(String string, Promise<T> promise) {
        return this.resolve(this.resolvesInProgress, string, promise, false);
    }

    @Override
    public Promise<List<T>> resolveAll(String string, Promise<List<T>> promise) {
        return this.resolve(this.resolveAllsInProgress, string, promise, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> Promise<U> resolve(ConcurrentMap<String, Promise<U>> concurrentMap, String string, Promise<U> promise, boolean bl2) {
        Promise<U> promise2 = concurrentMap.putIfAbsent(string, promise);
        if (promise2 != null) {
            if (promise2.isDone()) {
                InflightNameResolver.transferResult(promise2, promise);
            } else {
                promise2.addListener(new InflightNameResolver$1(this, promise));
            }
        } else {
            try {
                if (bl2) {
                    Promise promise3 = promise;
                    this.delegate.resolveAll(string, promise3);
                } else {
                    Promise promise4 = promise;
                    this.delegate.resolve(string, promise4);
                }
            }
            finally {
                if (promise.isDone()) {
                    concurrentMap.remove(string);
                } else {
                    promise.addListener(new InflightNameResolver$2(this, concurrentMap, string));
                }
            }
        }
        return promise;
    }

    private static <T> void transferResult(Future<T> future, Promise<T> promise) {
        if (future.isSuccess()) {
            promise.trySuccess(future.getNow());
        } else {
            promise.tryFailure(future.cause());
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.delegate + ')';
    }

    static /* synthetic */ void access$000(Future future, Promise promise) {
        InflightNameResolver.transferResult(future, promise);
    }
}

