/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsAddressDecoder;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsQueryLifecycleObserver;
import io.netty.resolver.dns.DnsResolveContext$1;
import io.netty.resolver.dns.DnsResolveContext$2;
import io.netty.resolver.dns.DnsResolveContext$3;
import io.netty.resolver.dns.DnsResolveContext$AuthoritativeNameServer;
import io.netty.resolver.dns.DnsResolveContext$AuthoritativeNameServerList;
import io.netty.resolver.dns.DnsResolveContext$DnsCacheIterable;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.resolver.dns.NoopDnsQueryLifecycleObserver;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.ThrowableUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

abstract class DnsResolveContext<T> {
    private static final FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>> RELEASE_RESPONSE = new DnsResolveContext$1();
    private static final RuntimeException NXDOMAIN_QUERY_FAILED_EXCEPTION = ThrowableUtil.unknownStackTrace(new RuntimeException("No answer found and NXDOMAIN response code returned"), DnsResolveContext.class, "onResponse(..)");
    private static final RuntimeException CNAME_NOT_FOUND_QUERY_FAILED_EXCEPTION = ThrowableUtil.unknownStackTrace(new RuntimeException("No matching CNAME record found"), DnsResolveContext.class, "onResponseCNAME(..)");
    private static final RuntimeException NO_MATCHING_RECORD_QUERY_FAILED_EXCEPTION = ThrowableUtil.unknownStackTrace(new RuntimeException("No matching record type found"), DnsResolveContext.class, "onResponseAorAAAA(..)");
    private static final RuntimeException UNRECOGNIZED_TYPE_QUERY_FAILED_EXCEPTION = ThrowableUtil.unknownStackTrace(new RuntimeException("Response type was unrecognized"), DnsResolveContext.class, "onResponse(..)");
    private static final RuntimeException NAME_SERVERS_EXHAUSTED_EXCEPTION = ThrowableUtil.unknownStackTrace(new RuntimeException("No name servers returned an answer"), DnsResolveContext.class, "tryToFinishResolve(..)");
    final DnsNameResolver parent;
    private final DnsServerAddressStream nameServerAddrs;
    private final String hostname;
    private final int dnsClass;
    private final DnsRecordType[] expectedTypes;
    private final int maxAllowedQueries;
    private final DnsRecord[] additionals;
    private final Set<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> queriesInProgress = Collections.newSetFromMap(new IdentityHashMap());
    private List<T> finalResult;
    private int allowedQueries;
    private boolean triedCNAME;

    DnsResolveContext(DnsNameResolver dnsNameResolver, String string, int n2, DnsRecordType[] dnsRecordTypeArray, DnsRecord[] dnsRecordArray, DnsServerAddressStream dnsServerAddressStream) {
        assert (dnsRecordTypeArray.length > 0);
        this.parent = dnsNameResolver;
        this.hostname = string;
        this.dnsClass = n2;
        this.expectedTypes = dnsRecordTypeArray;
        this.additionals = dnsRecordArray;
        this.nameServerAddrs = ObjectUtil.checkNotNull(dnsServerAddressStream, "nameServerAddrs");
        this.allowedQueries = this.maxAllowedQueries = dnsNameResolver.maxQueriesPerResolve();
    }

    abstract DnsResolveContext<T> newResolverContext(DnsNameResolver var1, String var2, int var3, DnsRecordType[] var4, DnsRecord[] var5, DnsServerAddressStream var6);

    abstract T convertRecord(DnsRecord var1, String var2, DnsRecord[] var3, EventLoop var4);

    abstract List<T> filterResults(List<T> var1);

    abstract void cache(String var1, DnsRecord[] var2, DnsRecord var3, T var4);

    abstract void cache(String var1, DnsRecord[] var2, UnknownHostException var3);

    void resolve(Promise<List<T>> promise) {
        String[] stringArray = this.parent.searchDomains();
        if (stringArray.length == 0 || this.parent.ndots() == 0 || StringUtil.endsWith(this.hostname, '.')) {
            this.internalResolve(promise);
        } else {
            boolean bl2 = this.hasNDots();
            String string = bl2 ? this.hostname : this.hostname + '.' + stringArray[0];
            int n2 = bl2 ? 0 : 1;
            this.doSearchDomainQuery(string, new DnsResolveContext$2(this, n2, promise, stringArray, bl2));
        }
    }

    private boolean hasNDots() {
        int n2 = 0;
        for (int i2 = this.hostname.length() - 1; i2 >= 0; --i2) {
            if (this.hostname.charAt(i2) != '.' || ++n2 < this.parent.ndots()) continue;
            return true;
        }
        return false;
    }

    private void doSearchDomainQuery(String string, FutureListener<List<T>> futureListener) {
        DnsResolveContext<T> dnsResolveContext = this.newResolverContext(this.parent, string, this.dnsClass, this.expectedTypes, this.additionals, this.nameServerAddrs);
        Promise<List<T>> promise = this.parent.executor().newPromise();
        super.internalResolve(promise);
        promise.addListener(futureListener);
    }

    private void internalResolve(Promise<List<T>> promise) {
        DnsServerAddressStream dnsServerAddressStream = this.getNameServers(this.hostname);
        int n2 = this.expectedTypes.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.query(this.hostname, this.expectedTypes[i2], dnsServerAddressStream.duplicate(), promise)) continue;
            return;
        }
        this.query(this.hostname, this.expectedTypes[n2], dnsServerAddressStream, promise);
    }

    private void addNameServerToCache(DnsResolveContext$AuthoritativeNameServer dnsResolveContext$AuthoritativeNameServer, InetAddress inetAddress, long l2) {
        if (!dnsResolveContext$AuthoritativeNameServer.isRootServer()) {
            this.parent.authoritativeDnsServerCache().cache(dnsResolveContext$AuthoritativeNameServer.domainName(), this.additionals, inetAddress, l2, this.parent.ch.eventLoop());
        }
    }

    private DnsServerAddressStream getNameServersFromCache(String string) {
        List<? extends DnsCacheEntry> list;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return null;
        }
        if (string.charAt(n3 - 1) != '.') {
            string = string + ".";
        }
        if ((n2 = string.indexOf(46)) == string.length() - 1) {
            return null;
        }
        do {
            int n4;
            if ((n4 = (string = string.substring(n2 + 1)).indexOf(46)) <= 0 || n4 == string.length() - 1) {
                return null;
            }
            n2 = n4;
        } while ((list = this.parent.authoritativeDnsServerCache().get(string, this.additionals)) == null || list.isEmpty());
        return DnsServerAddresses.sequential(new DnsResolveContext$DnsCacheIterable(this, list)).stream();
    }

    private void query(DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, Promise<List<T>> promise, Throwable throwable) {
        this.query(dnsServerAddressStream, n2, dnsQuestion, this.parent.dnsQueryLifecycleObserverFactory().newDnsQueryLifecycleObserver(dnsQuestion), promise, throwable);
    }

    private void query(DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise, Throwable throwable) {
        if (n2 >= dnsServerAddressStream.size() || this.allowedQueries == 0 || promise.isCancelled()) {
            this.tryToFinishResolve(dnsServerAddressStream, n2, dnsQuestion, dnsQueryLifecycleObserver, promise, throwable);
            return;
        }
        --this.allowedQueries;
        InetSocketAddress inetSocketAddress = dnsServerAddressStream.next();
        ChannelPromise channelPromise = this.parent.ch.newPromise();
        Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future = this.parent.query0(inetSocketAddress, dnsQuestion, this.additionals, channelPromise, this.parent.ch.eventLoop().newPromise());
        this.queriesInProgress.add(future);
        dnsQueryLifecycleObserver.queryWritten(inetSocketAddress, channelPromise);
        future.addListener(new DnsResolveContext$3(this, promise, dnsQueryLifecycleObserver, dnsServerAddressStream, n2, dnsQuestion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise) {
        try {
            DnsResponse dnsResponse = addressedEnvelope.content();
            DnsResponseCode dnsResponseCode = dnsResponse.code();
            if (dnsResponseCode == DnsResponseCode.NOERROR) {
                if (this.handleRedirect(dnsQuestion, addressedEnvelope, dnsQueryLifecycleObserver, promise)) {
                    return;
                }
                DnsRecordType dnsRecordType = dnsQuestion.type();
                if (dnsRecordType == DnsRecordType.CNAME) {
                    this.onResponseCNAME(dnsQuestion, DnsResolveContext.buildAliasMap(addressedEnvelope.content()), dnsQueryLifecycleObserver, promise);
                    return;
                }
                for (DnsRecordType dnsRecordType2 : this.expectedTypes) {
                    if (dnsRecordType != dnsRecordType2) continue;
                    this.onExpectedResponse(dnsQuestion, addressedEnvelope, dnsQueryLifecycleObserver, promise);
                    return;
                }
                dnsQueryLifecycleObserver.queryFailed(UNRECOGNIZED_TYPE_QUERY_FAILED_EXCEPTION);
                return;
            }
            if (dnsResponseCode != DnsResponseCode.NXDOMAIN) {
                this.query(dnsServerAddressStream, n2 + 1, dnsQuestion, dnsQueryLifecycleObserver.queryNoAnswer(dnsResponseCode), promise, null);
            } else {
                dnsQueryLifecycleObserver.queryFailed(NXDOMAIN_QUERY_FAILED_EXCEPTION);
            }
        }
        finally {
            ReferenceCountUtil.safeRelease(addressedEnvelope);
        }
    }

    private boolean handleRedirect(DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise) {
        DnsResolveContext$AuthoritativeNameServerList dnsResolveContext$AuthoritativeNameServerList;
        DnsResponse dnsResponse = addressedEnvelope.content();
        if (dnsResponse.count(DnsSection.ANSWER) == 0 && (dnsResolveContext$AuthoritativeNameServerList = DnsResolveContext.extractAuthoritativeNameServers(dnsQuestion.name(), dnsResponse)) != null) {
            ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(dnsResolveContext$AuthoritativeNameServerList.size());
            int n2 = dnsResponse.count(DnsSection.ADDITIONAL);
            for (int i2 = 0; i2 < n2; ++i2) {
                InetAddress inetAddress;
                String string;
                DnsResolveContext$AuthoritativeNameServer dnsResolveContext$AuthoritativeNameServer;
                Object t2 = dnsResponse.recordAt(DnsSection.ADDITIONAL, i2);
                if (t2.type() == DnsRecordType.A && !this.parent.supportsARecords() || t2.type() == DnsRecordType.AAAA && !this.parent.supportsAAAARecords() || (dnsResolveContext$AuthoritativeNameServer = dnsResolveContext$AuthoritativeNameServerList.remove(string = t2.name())) == null || (inetAddress = DnsAddressDecoder.decodeAddress(t2, string, this.parent.isDecodeIdn())) == null) continue;
                arrayList.add(new InetSocketAddress(inetAddress, this.parent.dnsRedirectPort(inetAddress)));
                this.addNameServerToCache(dnsResolveContext$AuthoritativeNameServer, inetAddress, t2.timeToLive());
            }
            if (!arrayList.isEmpty()) {
                this.query(this.parent.uncachedRedirectDnsServerStream(arrayList), 0, dnsQuestion, dnsQueryLifecycleObserver.queryRedirected(Collections.unmodifiableList(arrayList)), promise, null);
                return true;
            }
        }
        return false;
    }

    private static DnsResolveContext$AuthoritativeNameServerList extractAuthoritativeNameServers(String string, DnsResponse dnsResponse) {
        int n2 = dnsResponse.count(DnsSection.AUTHORITY);
        if (n2 == 0) {
            return null;
        }
        DnsResolveContext$AuthoritativeNameServerList dnsResolveContext$AuthoritativeNameServerList = new DnsResolveContext$AuthoritativeNameServerList(string);
        for (int i2 = 0; i2 < n2; ++i2) {
            dnsResolveContext$AuthoritativeNameServerList.add((DnsRecord)dnsResponse.recordAt(DnsSection.AUTHORITY, i2));
        }
        return dnsResolveContext$AuthoritativeNameServerList;
    }

    private void onExpectedResponse(DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise) {
        DnsResponse dnsResponse = addressedEnvelope.content();
        Map<String, String> map = DnsResolveContext.buildAliasMap(dnsResponse);
        int n2 = dnsResponse.count(DnsSection.ANSWER);
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            T t2;
            Object t3 = dnsResponse.recordAt(DnsSection.ANSWER, i2);
            DnsRecordType dnsRecordType = t3.type();
            boolean bl3 = false;
            for (DnsRecordType dnsRecordType2 : this.expectedTypes) {
                if (dnsRecordType != dnsRecordType2) continue;
                bl3 = true;
                break;
            }
            if (!bl3) continue;
            String string = dnsQuestion.name().toLowerCase(Locale.US);
            String string2 = t3.name().toLowerCase(Locale.US);
            if (!string2.equals(string)) {
                String string3 = string;
                while (!string2.equals(string3 = map.get(string3)) && string3 != null) {
                }
                if (string3 == null) continue;
            }
            if ((t2 = this.convertRecord((DnsRecord)t3, this.hostname, this.additionals, this.parent.ch.eventLoop())) == null) continue;
            if (this.finalResult == null) {
                this.finalResult = new ArrayList<T>(8);
            }
            this.finalResult.add(t2);
            this.cache(this.hostname, this.additionals, (DnsRecord)t3, t2);
            bl2 = true;
        }
        if (map.isEmpty()) {
            if (bl2) {
                dnsQueryLifecycleObserver.querySucceed();
                return;
            }
            dnsQueryLifecycleObserver.queryFailed(NO_MATCHING_RECORD_QUERY_FAILED_EXCEPTION);
        } else {
            dnsQueryLifecycleObserver.querySucceed();
            this.onResponseCNAME(dnsQuestion, map, this.parent.dnsQueryLifecycleObserverFactory().newDnsQueryLifecycleObserver(dnsQuestion), promise);
        }
    }

    private void onResponseCNAME(DnsQuestion dnsQuestion, Map<String, String> map, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise) {
        String string;
        String string2 = dnsQuestion.name().toLowerCase(Locale.US);
        boolean bl2 = false;
        while (!map.isEmpty() && (string = map.remove(string2)) != null) {
            bl2 = true;
            string2 = string;
        }
        if (bl2) {
            this.followCname(dnsQuestion, string2, dnsQueryLifecycleObserver, promise);
        } else {
            dnsQueryLifecycleObserver.queryFailed(CNAME_NOT_FOUND_QUERY_FAILED_EXCEPTION);
        }
    }

    private static Map<String, String> buildAliasMap(DnsResponse dnsResponse) {
        int n2 = dnsResponse.count(DnsSection.ANSWER);
        Map<String, String> map = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteBuf byteBuf;
            String string;
            Object t2 = dnsResponse.recordAt(DnsSection.ANSWER, i2);
            DnsRecordType dnsRecordType = t2.type();
            if (dnsRecordType != DnsRecordType.CNAME || !(t2 instanceof DnsRawRecord) || (string = DnsResolveContext.decodeDomainName(byteBuf = ((ByteBufHolder)t2).content())) == null) continue;
            if (map == null) {
                map = new HashMap<String, String>(Math.min(8, n2));
            }
            map.put(t2.name().toLowerCase(Locale.US), string.toLowerCase(Locale.US));
        }
        return map != null ? map : Collections.emptyMap();
    }

    private void tryToFinishResolve(DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise, Throwable throwable) {
        if (!this.queriesInProgress.isEmpty()) {
            dnsQueryLifecycleObserver.queryCancelled(this.allowedQueries);
            return;
        }
        if (this.finalResult == null) {
            if (n2 < dnsServerAddressStream.size()) {
                if (dnsQueryLifecycleObserver == NoopDnsQueryLifecycleObserver.INSTANCE) {
                    this.query(dnsServerAddressStream, n2 + 1, dnsQuestion, promise, throwable);
                } else {
                    this.query(dnsServerAddressStream, n2 + 1, dnsQuestion, dnsQueryLifecycleObserver, promise, throwable);
                }
                return;
            }
            dnsQueryLifecycleObserver.queryFailed(NAME_SERVERS_EXHAUSTED_EXCEPTION);
            if (throwable == null && !this.triedCNAME) {
                this.triedCNAME = true;
                this.query(this.hostname, DnsRecordType.CNAME, this.getNameServers(this.hostname), promise);
                return;
            }
        } else {
            dnsQueryLifecycleObserver.queryCancelled(this.allowedQueries);
        }
        this.finishResolve(promise, throwable);
    }

    private void finishResolve(Promise<List<T>> promise, Throwable throwable) {
        Object object;
        if (!this.queriesInProgress.isEmpty()) {
            Iterator<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> iterator = this.queriesInProgress.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                iterator.remove();
                if (object.cancel(false)) continue;
                object.addListener(RELEASE_RESPONSE);
            }
        }
        if (this.finalResult != null) {
            DnsNameResolver.trySuccess(promise, this.filterResults(this.finalResult));
            return;
        }
        int n2 = this.maxAllowedQueries - this.allowedQueries;
        object = new StringBuilder(64);
        ((StringBuilder)object).append("failed to resolve '").append(this.hostname).append('\'');
        if (n2 > 1) {
            if (n2 < this.maxAllowedQueries) {
                ((StringBuilder)object).append(" after ").append(n2).append(" queries ");
            } else {
                ((StringBuilder)object).append(". Exceeded max queries per resolve ").append(this.maxAllowedQueries).append(' ');
            }
        }
        UnknownHostException unknownHostException = new UnknownHostException(((StringBuilder)object).toString());
        if (throwable == null) {
            this.cache(this.hostname, this.additionals, unknownHostException);
        } else {
            unknownHostException.initCause(throwable);
        }
        promise.tryFailure(unknownHostException);
    }

    static String decodeDomainName(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        try {
            String string = DefaultDnsRecordDecoder.decodeName(byteBuf);
            return string;
        }
        catch (CorruptedFrameException corruptedFrameException) {
            String string = null;
            return string;
        }
        finally {
            byteBuf.resetReaderIndex();
        }
    }

    private DnsServerAddressStream getNameServers(String string) {
        DnsServerAddressStream dnsServerAddressStream = this.getNameServersFromCache(string);
        return dnsServerAddressStream == null ? this.nameServerAddrs.duplicate() : dnsServerAddressStream;
    }

    private void followCname(DnsQuestion dnsQuestion, String string, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise<List<T>> promise) {
        DnsQuestion dnsQuestion2;
        DnsServerAddressStream dnsServerAddressStream = this.getNameServers(string);
        try {
            dnsQuestion2 = this.newQuestion(string, dnsQuestion.type());
        }
        catch (Throwable throwable) {
            dnsQueryLifecycleObserver.queryFailed(throwable);
            PlatformDependent.throwException(throwable);
            return;
        }
        this.query(dnsServerAddressStream, 0, dnsQuestion2, dnsQueryLifecycleObserver.queryCNAMEd(dnsQuestion2), promise, null);
    }

    private boolean query(String string, DnsRecordType dnsRecordType, DnsServerAddressStream dnsServerAddressStream, Promise<List<T>> promise) {
        DnsQuestion dnsQuestion = this.newQuestion(string, dnsRecordType);
        if (dnsQuestion == null) {
            return false;
        }
        this.query(dnsServerAddressStream, 0, dnsQuestion, promise, null);
        return true;
    }

    private DnsQuestion newQuestion(String string, DnsRecordType dnsRecordType) {
        try {
            return new DefaultDnsQuestion(string, dnsRecordType, this.dnsClass);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static /* synthetic */ String access$000(DnsResolveContext dnsResolveContext) {
        return dnsResolveContext.hostname;
    }

    static /* synthetic */ void access$100(DnsResolveContext dnsResolveContext, String string, FutureListener futureListener) {
        dnsResolveContext.doSearchDomainQuery(string, futureListener);
    }

    static /* synthetic */ void access$200(DnsResolveContext dnsResolveContext, Promise promise) {
        dnsResolveContext.internalResolve(promise);
    }

    static /* synthetic */ Set access$400(DnsResolveContext dnsResolveContext) {
        return dnsResolveContext.queriesInProgress;
    }

    static /* synthetic */ int access$500(DnsResolveContext dnsResolveContext) {
        return dnsResolveContext.allowedQueries;
    }

    static /* synthetic */ void access$600(DnsResolveContext dnsResolveContext, DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, AddressedEnvelope addressedEnvelope, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise promise) {
        dnsResolveContext.onResponse(dnsServerAddressStream, n2, dnsQuestion, addressedEnvelope, dnsQueryLifecycleObserver, promise);
    }

    static /* synthetic */ void access$700(DnsResolveContext dnsResolveContext, DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, Promise promise, Throwable throwable) {
        dnsResolveContext.query(dnsServerAddressStream, n2, dnsQuestion, promise, throwable);
    }

    static /* synthetic */ void access$800(DnsResolveContext dnsResolveContext, DnsServerAddressStream dnsServerAddressStream, int n2, DnsQuestion dnsQuestion, DnsQueryLifecycleObserver dnsQueryLifecycleObserver, Promise promise, Throwable throwable) {
        dnsResolveContext.tryToFinishResolve(dnsServerAddressStream, n2, dnsQuestion, dnsQueryLifecycleObserver, promise, throwable);
    }
}

