/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsResolveContext;
import io.netty.resolver.dns.DnsResolveContext$AuthoritativeNameServer;
import java.util.Locale;

final class DnsResolveContext$AuthoritativeNameServerList {
    private final String questionName;
    private DnsResolveContext$AuthoritativeNameServer head;
    private int count;

    DnsResolveContext$AuthoritativeNameServerList(String string) {
        this.questionName = string.toLowerCase(Locale.US);
    }

    void add(DnsRecord dnsRecord) {
        if (dnsRecord.type() != DnsRecordType.NS || !(dnsRecord instanceof DnsRawRecord)) {
            return;
        }
        if (this.questionName.length() < dnsRecord.name().length()) {
            return;
        }
        String string = dnsRecord.name().toLowerCase(Locale.US);
        int n2 = 0;
        int n3 = string.length() - 1;
        int n4 = this.questionName.length() - 1;
        while (n3 >= 0) {
            char c2 = string.charAt(n3);
            if (this.questionName.charAt(n4) != c2) {
                return;
            }
            if (c2 == '.') {
                ++n2;
            }
            --n3;
            --n4;
        }
        if (this.head != null && this.head.dots > n2) {
            return;
        }
        ByteBuf byteBuf = ((ByteBufHolder)((Object)dnsRecord)).content();
        String string2 = DnsResolveContext.decodeDomainName(byteBuf);
        if (string2 == null) {
            return;
        }
        if (this.head == null || this.head.dots < n2) {
            this.count = 1;
            this.head = new DnsResolveContext$AuthoritativeNameServer(n2, string, string2);
        } else if (this.head.dots == n2) {
            DnsResolveContext$AuthoritativeNameServer dnsResolveContext$AuthoritativeNameServer = this.head;
            while (dnsResolveContext$AuthoritativeNameServer.next != null) {
                dnsResolveContext$AuthoritativeNameServer = dnsResolveContext$AuthoritativeNameServer.next;
            }
            dnsResolveContext$AuthoritativeNameServer.next = new DnsResolveContext$AuthoritativeNameServer(n2, string, string2);
            ++this.count;
        }
    }

    DnsResolveContext$AuthoritativeNameServer remove(String string) {
        DnsResolveContext$AuthoritativeNameServer dnsResolveContext$AuthoritativeNameServer = this.head;
        while (dnsResolveContext$AuthoritativeNameServer != null) {
            if (!dnsResolveContext$AuthoritativeNameServer.removed && dnsResolveContext$AuthoritativeNameServer.nsName.equalsIgnoreCase(string)) {
                dnsResolveContext$AuthoritativeNameServer.removed = true;
                return dnsResolveContext$AuthoritativeNameServer;
            }
            dnsResolveContext$AuthoritativeNameServer = dnsResolveContext$AuthoritativeNameServer.next;
        }
        return null;
    }

    int size() {
        return this.count;
    }
}

