/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsQueryContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;

final class DnsNameResolver$DnsResponseHandler
extends ChannelInboundHandlerAdapter {
    private final Promise<Channel> channelActivePromise;
    final /* synthetic */ DnsNameResolver this$0;

    DnsNameResolver$DnsResponseHandler(DnsNameResolver dnsNameResolver, Promise<Channel> promise) {
        this.this$0 = dnsNameResolver;
        this.channelActivePromise = promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        try {
            DnsQueryContext dnsQueryContext;
            DatagramDnsResponse datagramDnsResponse = (DatagramDnsResponse)object;
            int n2 = datagramDnsResponse.id();
            if (DnsNameResolver.access$500().isDebugEnabled()) {
                DnsNameResolver.access$500().debug("{} RECEIVED: [{}: {}], {}", this.this$0.ch, n2, datagramDnsResponse.sender(), datagramDnsResponse);
            }
            if ((dnsQueryContext = this.this$0.queryContextManager.get(datagramDnsResponse.sender(), n2)) == null) {
                DnsNameResolver.access$500().warn("{} Received a DNS response with an unknown ID: {}", (Object)this.this$0.ch, (Object)n2);
                return;
            }
            dnsQueryContext.finish(datagramDnsResponse);
        }
        finally {
            ReferenceCountUtil.safeRelease(object);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        super.channelActive(channelHandlerContext);
        this.channelActivePromise.setSuccess(channelHandlerContext.channel());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        DnsNameResolver.access$500().warn("{} Unexpected exception: ", (Object)this.this$0.ch, (Object)throwable);
    }

    static /* synthetic */ Promise access$300(DnsNameResolver$DnsResponseHandler dnsNameResolver$DnsResponseHandler) {
        return dnsNameResolver$DnsResponseHandler.channelActivePromise;
    }
}

