/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsAddressDecoder;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsResolveContext;
import io.netty.resolver.dns.DnsServerAddressStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

final class DnsAddressResolveContext
extends DnsResolveContext<InetAddress> {
    private final DnsCache resolveCache;

    DnsAddressResolveContext(DnsNameResolver dnsNameResolver, String string, DnsRecord[] dnsRecordArray, DnsServerAddressStream dnsServerAddressStream, DnsCache dnsCache) {
        super(dnsNameResolver, string, 1, dnsNameResolver.resolveRecordTypes(), dnsRecordArray, dnsServerAddressStream);
        this.resolveCache = dnsCache;
    }

    @Override
    DnsResolveContext<InetAddress> newResolverContext(DnsNameResolver dnsNameResolver, String string, int n2, DnsRecordType[] dnsRecordTypeArray, DnsRecord[] dnsRecordArray, DnsServerAddressStream dnsServerAddressStream) {
        return new DnsAddressResolveContext(dnsNameResolver, string, dnsRecordArray, dnsServerAddressStream, this.resolveCache);
    }

    @Override
    InetAddress convertRecord(DnsRecord dnsRecord, String string, DnsRecord[] dnsRecordArray, EventLoop eventLoop) {
        return DnsAddressDecoder.decodeAddress(dnsRecord, string, this.parent.isDecodeIdn());
    }

    @Override
    List<InetAddress> filterResults(List<InetAddress> list) {
        Class<? extends InetAddress> clazz = this.parent.preferredAddressType().addressType();
        int n2 = list.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            InetAddress inetAddress = list.get(i2);
            if (!clazz.isInstance(inetAddress)) continue;
            ++n3;
        }
        if (n3 == n2 || n3 == 0) {
            return list;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(n3);
        for (int i3 = 0; i3 < n2; ++i3) {
            InetAddress inetAddress = list.get(i3);
            if (!clazz.isInstance(inetAddress)) continue;
            arrayList.add(inetAddress);
        }
        return arrayList;
    }

    @Override
    void cache(String string, DnsRecord[] dnsRecordArray, DnsRecord dnsRecord, InetAddress inetAddress) {
        this.resolveCache.cache(string, dnsRecordArray, inetAddress, dnsRecord.timeToLive(), this.parent.ch.eventLoop());
    }

    @Override
    void cache(String string, DnsRecord[] dnsRecordArray, UnknownHostException unknownHostException) {
        this.resolveCache.cache(string, dnsRecordArray, unknownHostException, this.parent.ch.eventLoop());
    }
}

