/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.resolver.dns.DefaultDnsCache$1;
import io.netty.resolver.dns.DefaultDnsCache$DefaultDnsCacheEntry;
import io.netty.resolver.dns.DefaultDnsCache$Entries;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class DefaultDnsCache
implements DnsCache {
    private final ConcurrentMap<String, DefaultDnsCache$Entries> resolveCache = PlatformDependent.newConcurrentHashMap();
    private static final int MAX_SUPPORTED_TTL_SECS = (int)TimeUnit.DAYS.toSeconds(730L);
    private final int minTtl;
    private final int maxTtl;
    private final int negativeTtl;

    public DefaultDnsCache() {
        this(0, MAX_SUPPORTED_TTL_SECS, 0);
    }

    public DefaultDnsCache(int n2, int n3, int n4) {
        this.minTtl = Math.min(MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositiveOrZero(n2, "minTtl"));
        this.maxTtl = Math.min(MAX_SUPPORTED_TTL_SECS, ObjectUtil.checkPositiveOrZero(n3, "maxTtl"));
        if (n2 > n3) {
            throw new IllegalArgumentException("minTtl: " + n2 + ", maxTtl: " + n3 + " (expected: 0 <= minTtl <= maxTtl)");
        }
        this.negativeTtl = ObjectUtil.checkPositiveOrZero(n4, "negativeTtl");
    }

    public int minTtl() {
        return this.minTtl;
    }

    public int maxTtl() {
        return this.maxTtl;
    }

    public int negativeTtl() {
        return this.negativeTtl;
    }

    @Override
    public void clear() {
        while (!this.resolveCache.isEmpty()) {
            Iterator iterator = this.resolveCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                iterator.remove();
                ((DefaultDnsCache$Entries)entry.getValue()).clearAndCancel();
            }
        }
    }

    @Override
    public boolean clear(String string) {
        ObjectUtil.checkNotNull(string, "hostname");
        DefaultDnsCache$Entries defaultDnsCache$Entries = (DefaultDnsCache$Entries)this.resolveCache.remove(string);
        return defaultDnsCache$Entries != null && defaultDnsCache$Entries.clearAndCancel();
    }

    private static boolean emptyAdditionals(DnsRecord[] dnsRecordArray) {
        return dnsRecordArray == null || dnsRecordArray.length == 0;
    }

    @Override
    public List<? extends DnsCacheEntry> get(String string, DnsRecord[] dnsRecordArray) {
        ObjectUtil.checkNotNull(string, "hostname");
        if (!DefaultDnsCache.emptyAdditionals(dnsRecordArray)) {
            return Collections.emptyList();
        }
        DefaultDnsCache$Entries defaultDnsCache$Entries = (DefaultDnsCache$Entries)this.resolveCache.get(string);
        return defaultDnsCache$Entries == null ? null : (List)defaultDnsCache$Entries.get();
    }

    @Override
    public DnsCacheEntry cache(String string, DnsRecord[] dnsRecordArray, InetAddress inetAddress, long l2, EventLoop eventLoop) {
        ObjectUtil.checkNotNull(string, "hostname");
        ObjectUtil.checkNotNull(inetAddress, "address");
        ObjectUtil.checkNotNull(eventLoop, "loop");
        DefaultDnsCache$DefaultDnsCacheEntry defaultDnsCache$DefaultDnsCacheEntry = new DefaultDnsCache$DefaultDnsCacheEntry(string, inetAddress);
        if (this.maxTtl == 0 || !DefaultDnsCache.emptyAdditionals(dnsRecordArray)) {
            return defaultDnsCache$DefaultDnsCacheEntry;
        }
        this.cache0(defaultDnsCache$DefaultDnsCacheEntry, Math.max(this.minTtl, Math.min(MAX_SUPPORTED_TTL_SECS, (int)Math.min((long)this.maxTtl, l2))), eventLoop);
        return defaultDnsCache$DefaultDnsCacheEntry;
    }

    @Override
    public DnsCacheEntry cache(String string, DnsRecord[] dnsRecordArray, Throwable throwable, EventLoop eventLoop) {
        ObjectUtil.checkNotNull(string, "hostname");
        ObjectUtil.checkNotNull(throwable, "cause");
        ObjectUtil.checkNotNull(eventLoop, "loop");
        DefaultDnsCache$DefaultDnsCacheEntry defaultDnsCache$DefaultDnsCacheEntry = new DefaultDnsCache$DefaultDnsCacheEntry(string, throwable);
        if (this.negativeTtl == 0 || !DefaultDnsCache.emptyAdditionals(dnsRecordArray)) {
            return defaultDnsCache$DefaultDnsCacheEntry;
        }
        this.cache0(defaultDnsCache$DefaultDnsCacheEntry, Math.min(MAX_SUPPORTED_TTL_SECS, this.negativeTtl), eventLoop);
        return defaultDnsCache$DefaultDnsCacheEntry;
    }

    private void cache0(DefaultDnsCache$DefaultDnsCacheEntry defaultDnsCache$DefaultDnsCacheEntry, int n2, EventLoop eventLoop) {
        DefaultDnsCache$Entries defaultDnsCache$Entries = (DefaultDnsCache$Entries)this.resolveCache.get(defaultDnsCache$DefaultDnsCacheEntry.hostname());
        if (defaultDnsCache$Entries == null) {
            defaultDnsCache$Entries = new DefaultDnsCache$Entries(defaultDnsCache$DefaultDnsCacheEntry);
            DefaultDnsCache$Entries defaultDnsCache$Entries2 = this.resolveCache.putIfAbsent(defaultDnsCache$DefaultDnsCacheEntry.hostname(), defaultDnsCache$Entries);
            if (defaultDnsCache$Entries2 != null) {
                defaultDnsCache$Entries = defaultDnsCache$Entries2;
            }
        }
        defaultDnsCache$Entries.add(defaultDnsCache$DefaultDnsCacheEntry);
        this.scheduleCacheExpiration(defaultDnsCache$DefaultDnsCacheEntry, n2, eventLoop);
    }

    private void scheduleCacheExpiration(DefaultDnsCache$DefaultDnsCacheEntry defaultDnsCache$DefaultDnsCacheEntry, int n2, EventLoop eventLoop) {
        defaultDnsCache$DefaultDnsCacheEntry.scheduleExpiration(eventLoop, new DefaultDnsCache$1(this, defaultDnsCache$DefaultDnsCacheEntry), n2, TimeUnit.SECONDS);
    }

    public String toString() {
        return "DefaultDnsCache(minTtl=" + this.minTtl + ", maxTtl=" + this.maxTtl + ", negativeTtl=" + this.negativeTtl + ", cached resolved hostname=" + this.resolveCache.size() + ")";
    }

    static /* synthetic */ ConcurrentMap access$100(DefaultDnsCache defaultDnsCache) {
        return defaultDnsCache.resolveCache;
    }
}

