/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

final class DefaultDnsCache$DefaultDnsCacheEntry
implements DnsCacheEntry {
    private final String hostname;
    private final InetAddress address;
    private final Throwable cause;
    private volatile ScheduledFuture<?> expirationFuture;
    static final /* synthetic */ boolean $assertionsDisabled;

    DefaultDnsCache$DefaultDnsCacheEntry(String string, InetAddress inetAddress) {
        this.hostname = ObjectUtil.checkNotNull(string, "hostname");
        this.address = ObjectUtil.checkNotNull(inetAddress, "address");
        this.cause = null;
    }

    DefaultDnsCache$DefaultDnsCacheEntry(String string, Throwable throwable) {
        this.hostname = ObjectUtil.checkNotNull(string, "hostname");
        this.cause = ObjectUtil.checkNotNull(throwable, "cause");
        this.address = null;
    }

    @Override
    public InetAddress address() {
        return this.address;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    String hostname() {
        return this.hostname;
    }

    void scheduleExpiration(EventLoop eventLoop, Runnable runnable, long l2, TimeUnit timeUnit) {
        if (!$assertionsDisabled && this.expirationFuture != null) {
            throw new AssertionError((Object)"expiration task scheduled already");
        }
        this.expirationFuture = eventLoop.schedule(runnable, l2, timeUnit);
    }

    void cancelExpiration() {
        ScheduledFuture<?> scheduledFuture = this.expirationFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    public String toString() {
        if (this.cause != null) {
            return this.hostname + '/' + this.cause;
        }
        return this.address.toString();
    }

    static /* synthetic */ String access$000(DefaultDnsCache$DefaultDnsCacheEntry defaultDnsCache$DefaultDnsCacheEntry) {
        return defaultDnsCache$DefaultDnsCacheEntry.hostname;
    }

    static {
        $assertionsDisabled = !DefaultDnsCache.class.desiredAssertionStatus();
    }
}

