/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.InetSocketAddressResolver$1;
import io.netty.resolver.InetSocketAddressResolver$2;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;

public class InetSocketAddressResolver
extends AbstractAddressResolver<InetSocketAddress> {
    final NameResolver<InetAddress> nameResolver;

    public InetSocketAddressResolver(EventExecutor eventExecutor, NameResolver<InetAddress> nameResolver) {
        super(eventExecutor, InetSocketAddress.class);
        this.nameResolver = nameResolver;
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress inetSocketAddress) {
        return !inetSocketAddress.isUnresolved();
    }

    @Override
    protected void doResolve(InetSocketAddress inetSocketAddress, Promise<InetSocketAddress> promise) {
        this.nameResolver.resolve(inetSocketAddress.getHostName()).addListener(new InetSocketAddressResolver$1(this, promise, inetSocketAddress));
    }

    @Override
    protected void doResolveAll(InetSocketAddress inetSocketAddress, Promise<List<InetSocketAddress>> promise) {
        this.nameResolver.resolveAll(inetSocketAddress.getHostName()).addListener(new InetSocketAddressResolver$2(this, inetSocketAddress, promise));
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

