/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.CompositeNameResolver$1;
import io.netty.resolver.CompositeNameResolver$2;
import io.netty.resolver.NameResolver;
import io.netty.resolver.SimpleNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.List;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    public CompositeNameResolver(EventExecutor eventExecutor, NameResolver<T> ... nameResolverArray) {
        super(eventExecutor);
        ObjectUtil.checkNotNull(nameResolverArray, "resolvers");
        for (int i2 = 0; i2 < nameResolverArray.length; ++i2) {
            if (nameResolverArray[i2] != null) continue;
            throw new NullPointerException("resolvers[" + i2 + ']');
        }
        if (nameResolverArray.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(nameResolverArray) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])nameResolverArray.clone();
    }

    @Override
    protected void doResolve(String string, Promise<T> promise) {
        this.doResolveRec(string, promise, 0, null);
    }

    private void doResolveRec(String string, Promise<T> promise, int n2, Throwable throwable) {
        if (n2 >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n2];
            nameResolver.resolve(string).addListener(new CompositeNameResolver$1(this, promise, string, n2));
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<T>> promise) {
        this.doResolveAllRec(string, promise, 0, null);
    }

    private void doResolveAllRec(String string, Promise<List<T>> promise, int n2, Throwable throwable) {
        if (n2 >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n2];
            nameResolver.resolveAll(string).addListener(new CompositeNameResolver$2(this, promise, string, n2));
        }
    }

    static /* synthetic */ void access$000(CompositeNameResolver compositeNameResolver, String string, Promise promise, int n2, Throwable throwable) {
        compositeNameResolver.doResolveRec(string, promise, n2, throwable);
    }

    static /* synthetic */ void access$100(CompositeNameResolver compositeNameResolver, String string, Promise promise, int n2, Throwable throwable) {
        compositeNameResolver.doResolveAllRec(string, promise, n2, throwable);
    }
}

