/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedWriteHandler$1;
import io.netty.handler.stream.ChunkedWriteHandler$2;
import io.netty.handler.stream.ChunkedWriteHandler$3;
import io.netty.handler.stream.ChunkedWriteHandler$4;
import io.netty.handler.stream.ChunkedWriteHandler$PendingWrite;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<ChunkedWriteHandler$PendingWrite> queue = new ArrayDeque<ChunkedWriteHandler$PendingWrite>();
    private volatile ChannelHandlerContext ctx;
    private ChunkedWriteHandler$PendingWrite currentWrite;

    public ChunkedWriteHandler() {
    }

    @Deprecated
    public ChunkedWriteHandler(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxPendingWrites: " + n2 + " (expected: > 0)");
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    public void resumeTransfer() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            return;
        }
        if (channelHandlerContext.executor().inEventLoop()) {
            this.resumeTransfer0(channelHandlerContext);
        } else {
            channelHandlerContext.executor().execute(new ChunkedWriteHandler$1(this, channelHandlerContext));
        }
    }

    private void resumeTransfer0(ChannelHandlerContext channelHandlerContext) {
        block2: {
            try {
                this.doFlush(channelHandlerContext);
            }
            catch (Exception exception) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Unexpected exception while sending chunks.", exception);
            }
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.queue.add(new ChunkedWriteHandler$PendingWrite(object, channelPromise));
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.doFlush(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    private void discard(Throwable throwable) {
        while (true) {
            ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite = this.currentWrite;
            if (this.currentWrite == null) {
                chunkedWriteHandler$PendingWrite = this.queue.poll();
            } else {
                this.currentWrite = null;
            }
            if (chunkedWriteHandler$PendingWrite == null) break;
            Object object = chunkedWriteHandler$PendingWrite.msg;
            if (object instanceof ChunkedInput) {
                ChunkedInput chunkedInput = (ChunkedInput)object;
                try {
                    if (!chunkedInput.isEndOfInput()) {
                        if (throwable == null) {
                            throwable = new ClosedChannelException();
                        }
                        chunkedWriteHandler$PendingWrite.fail(throwable);
                    } else {
                        chunkedWriteHandler$PendingWrite.success(chunkedInput.length());
                    }
                    ChunkedWriteHandler.closeInput(chunkedInput);
                }
                catch (Exception exception) {
                    chunkedWriteHandler$PendingWrite.fail(exception);
                    logger.warn(ChunkedInput.class.getSimpleName() + ".isEndOfInput() failed", exception);
                    ChunkedWriteHandler.closeInput(chunkedInput);
                }
                continue;
            }
            if (throwable == null) {
                throwable = new ClosedChannelException();
            }
            chunkedWriteHandler$PendingWrite.fail(throwable);
        }
    }

    private void doFlush(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return;
        }
        boolean bl2 = true;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        while (channel.isWritable()) {
            if (this.currentWrite == null) {
                this.currentWrite = this.queue.poll();
            }
            if (this.currentWrite == null) break;
            ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite = this.currentWrite;
            Object object = chunkedWriteHandler$PendingWrite.msg;
            if (object instanceof ChunkedInput) {
                boolean bl3;
                boolean bl4;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                ByteBuf byteBuf = null;
                try {
                    byteBuf = (ByteBuf)chunkedInput.readChunk(byteBufAllocator);
                    bl4 = chunkedInput.isEndOfInput();
                    bl3 = byteBuf == null ? !bl4 : false;
                }
                catch (Throwable throwable) {
                    this.currentWrite = null;
                    if (byteBuf != null) {
                        ReferenceCountUtil.release(byteBuf);
                    }
                    chunkedWriteHandler$PendingWrite.fail(throwable);
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    break;
                }
                if (bl3) break;
                if (byteBuf == null) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                }
                ChannelFuture channelFuture = channelHandlerContext.write(byteBuf);
                if (bl4) {
                    this.currentWrite = null;
                    channelFuture.addListener(new ChunkedWriteHandler$2(this, chunkedWriteHandler$PendingWrite, chunkedInput));
                } else if (channel.isWritable()) {
                    channelFuture.addListener(new ChunkedWriteHandler$3(this, object, chunkedWriteHandler$PendingWrite, chunkedInput));
                } else {
                    channelFuture.addListener(new ChunkedWriteHandler$4(this, object, chunkedWriteHandler$PendingWrite, chunkedInput, channel));
                }
                channelHandlerContext.flush();
                bl2 = false;
            } else {
                this.currentWrite = null;
                channelHandlerContext.write(object, chunkedWriteHandler$PendingWrite.promise);
                bl2 = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (bl2) {
            channelHandlerContext.flush();
        }
    }

    private static void closeInput(ChunkedInput<?> chunkedInput) {
        block2: {
            try {
                chunkedInput.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a chunked input.", throwable);
            }
        }
    }

    static /* synthetic */ void access$000(ChunkedWriteHandler chunkedWriteHandler, ChannelHandlerContext channelHandlerContext) {
        chunkedWriteHandler.resumeTransfer0(channelHandlerContext);
    }

    static /* synthetic */ void access$100(ChunkedInput chunkedInput) {
        ChunkedWriteHandler.closeInput(chunkedInput);
    }
}

