/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.RandomAccessFile;

public class ChunkedFile
implements ChunkedInput<ByteBuf> {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedFile(File file) {
        this(file, 8192);
    }

    public ChunkedFile(File file, int n2) {
        this(new RandomAccessFile(file, "r"), n2);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 8192);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile, int n2) {
        this(randomAccessFile, 0L, randomAccessFile.length(), n2);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile, long l2, long l3, int n2) {
        if (randomAccessFile == null) {
            throw new NullPointerException("file");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("offset: " + l2 + " (expected: 0 or greater)");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length: " + l3 + " (expected: 0 or greater)");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n2 + " (expected: a positive integer)");
        }
        this.file = randomAccessFile;
        this.offset = this.startOffset = l2;
        this.endOffset = l2 + l3;
        this.chunkSize = n2;
        randomAccessFile.seek(l2);
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        return this.offset >= this.endOffset || !this.file.getChannel().isOpen();
    }

    @Override
    public void close() {
        this.file.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        long l2 = this.offset;
        if (l2 >= this.endOffset) {
            return null;
        }
        int n2 = (int)Math.min((long)this.chunkSize, this.endOffset - l2);
        ByteBuf byteBuf = byteBufAllocator.heapBuffer(n2);
        boolean bl2 = true;
        try {
            this.file.readFully(byteBuf.array(), byteBuf.arrayOffset(), n2);
            byteBuf.writerIndex(n2);
            this.offset = l2 + (long)n2;
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

