/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactory$1;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactory$2;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.StringUtil;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private static final int SHA1_BYTE_LEN = 20;
    private static final int SHA1_HEX_LEN = 40;
    private static final FastThreadLocal<MessageDigest> tlmd = new FingerprintTrustManagerFactory$1();
    private final TrustManager tm = new FingerprintTrustManagerFactory$2(this);
    private final byte[][] fingerprints;

    public FingerprintTrustManagerFactory(Iterable<String> iterable) {
        this(FingerprintTrustManagerFactory.toFingerprintArray(iterable));
    }

    public FingerprintTrustManagerFactory(String ... stringArray) {
        this(FingerprintTrustManagerFactory.toFingerprintArray(Arrays.asList(stringArray)));
    }

    public FingerprintTrustManagerFactory(byte[] ... byArray) {
        if (byArray == null) {
            throw new NullPointerException("fingerprints");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(byArray.length);
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) break;
            if (byArray2.length != 20) {
                throw new IllegalArgumentException("malformed fingerprint: " + ByteBufUtil.hexDump(Unpooled.wrappedBuffer(byArray2)) + " (expected: SHA1)");
            }
            arrayList.add(byArray2.clone());
        }
        this.fingerprints = (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
    }

    private static byte[][] toFingerprintArray(Iterable<String> iterable) {
        if (iterable == null) {
            throw new NullPointerException("fingerprints");
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (String string : iterable) {
            if (string == null) break;
            if (!FINGERPRINT_PATTERN.matcher(string).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + string);
            }
            if ((string = FINGERPRINT_STRIP_PATTERN.matcher(string).replaceAll("")).length() != 40) {
                throw new IllegalArgumentException("malformed fingerprint: " + string + " (expected: SHA1)");
            }
            arrayList.add(StringUtil.decodeHexDump(string));
        }
        return (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
    }

    @Override
    protected void engineInit(KeyStore keyStore) {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }

    static /* synthetic */ byte[][] access$000(FingerprintTrustManagerFactory fingerprintTrustManagerFactory) {
        return fingerprintTrustManagerFactory.fingerprints;
    }

    static /* synthetic */ FastThreadLocal access$100() {
        return tlmd;
    }
}

