/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import io.netty.util.internal.EmptyArrays;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;

class FingerprintTrustManagerFactory$2
implements X509TrustManager {
    final /* synthetic */ FingerprintTrustManagerFactory this$0;

    FingerprintTrustManagerFactory$2(FingerprintTrustManagerFactory fingerprintTrustManagerFactory) {
        this.this$0 = fingerprintTrustManagerFactory;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        this.checkTrusted("client", x509CertificateArray);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        this.checkTrusted("server", x509CertificateArray);
    }

    private void checkTrusted(String string, X509Certificate[] x509CertificateArray) {
        X509Certificate x509Certificate = x509CertificateArray[0];
        byte[] byArray = this.fingerprint(x509Certificate);
        boolean bl2 = false;
        for (byte[] byArray2 : FingerprintTrustManagerFactory.access$000(this.this$0)) {
            if (!Arrays.equals(byArray, byArray2)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new CertificateException(string + " certificate with unknown fingerprint: " + x509Certificate.getSubjectDN());
        }
    }

    private byte[] fingerprint(X509Certificate x509Certificate) {
        MessageDigest messageDigest = (MessageDigest)FingerprintTrustManagerFactory.access$100().get();
        messageDigest.reset();
        return messageDigest.digest(x509Certificate.getEncoded());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EmptyArrays.EMPTY_X509_CERTIFICATES;
    }
}

