/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;

final class SslUtils {
    static final String PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    static final String PROTOCOL_SSL_V2 = "SSLv2";
    static final String PROTOCOL_SSL_V3 = "SSLv3";
    static final String PROTOCOL_TLS_V1 = "TLSv1";
    static final String PROTOCOL_TLS_V1_1 = "TLSv1.1";
    static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    static final int SSL_CONTENT_TYPE_ALERT = 21;
    static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    static final int SSL_CONTENT_TYPE_EXTENSION_HEARTBEAT = 24;
    static final int SSL_RECORD_HEADER_LENGTH = 5;
    static final int NOT_ENOUGH_DATA = -1;
    static final int NOT_ENCRYPTED = -2;
    static final String[] DEFAULT_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};

    static void addIfSupported(Set<String> set, List<String> list, String ... stringArray) {
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            list.add(string);
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, Iterable<String> iterable) {
        if (list.isEmpty()) {
            for (String string : iterable) {
                if (string.startsWith("SSL_") || string.contains("_RC4_")) continue;
                list.add(string);
            }
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, String ... stringArray) {
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(list, Arrays.asList(stringArray));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable throwable) {
        if (throwable instanceof SSLHandshakeException) {
            return (SSLHandshakeException)throwable;
        }
        return (SSLHandshakeException)new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
    }

    static int getEncryptedPacketLength(ByteBuf byteBuf, int n2) {
        int n3;
        boolean bl2;
        int n4 = 0;
        switch (byteBuf.getUnsignedByte(n2)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            n3 = byteBuf.getUnsignedByte(n2 + 1);
            if (n3 == 3) {
                n4 = SslUtils.unsignedShortBE(byteBuf, n2 + 3) + 5;
                if (n4 <= 5) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        if (!bl2) {
            n3 = (byteBuf.getUnsignedByte(n2) & 0x80) != 0 ? 2 : 3;
            short s2 = byteBuf.getUnsignedByte(n2 + n3 + 1);
            if (s2 == 2 || s2 == 3) {
                int n5 = n4 = n3 == 2 ? (SslUtils.shortBE(byteBuf, n2) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuf, n2) & 0x3FFF) + 3;
                if (n4 <= n3) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n4;
    }

    private static int unsignedShortBE(ByteBuf byteBuf, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.getUnsignedShort(n2) : byteBuf.getUnsignedShortLE(n2);
    }

    private static short shortBE(ByteBuf byteBuf, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.getShort(n2) : byteBuf.getShortLE(n2);
    }

    private static short unsignedByte(byte by2) {
        return (short)(by2 & 0xFF);
    }

    private static int unsignedShortBE(ByteBuffer byteBuffer, int n2) {
        return SslUtils.shortBE(byteBuffer, n2) & 0xFFFF;
    }

    private static short shortBE(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.order() == ByteOrder.BIG_ENDIAN ? byteBuffer.getShort(n2) : ByteBufUtil.swapShort(byteBuffer.getShort(n2));
    }

    static int getEncryptedPacketLength(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[n2];
        if (byteBuffer.remaining() >= 5) {
            return SslUtils.getEncryptedPacketLength(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5);
        do {
            if ((byteBuffer = byteBufferArray[n2++].duplicate()).remaining() > byteBuffer2.remaining()) {
                byteBuffer.limit(byteBuffer.position() + byteBuffer2.remaining());
            }
            byteBuffer2.put(byteBuffer);
        } while (byteBuffer2.hasRemaining());
        byteBuffer2.flip();
        return SslUtils.getEncryptedPacketLength(byteBuffer2);
    }

    private static int getEncryptedPacketLength(ByteBuffer byteBuffer) {
        int n2;
        boolean bl2;
        int n3 = 0;
        int n4 = byteBuffer.position();
        switch (SslUtils.unsignedByte(byteBuffer.get(n4))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            n2 = SslUtils.unsignedByte(byteBuffer.get(n4 + 1));
            if (n2 == 3) {
                n3 = SslUtils.unsignedShortBE(byteBuffer, n4 + 3) + 5;
                if (n3 <= 5) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        if (!bl2) {
            n2 = (SslUtils.unsignedByte(byteBuffer.get(n4)) & 0x80) != 0 ? 2 : 3;
            short s2 = SslUtils.unsignedByte(byteBuffer.get(n4 + n2 + 1));
            if (s2 == 2 || s2 == 3) {
                int n5 = n3 = n2 == 2 ? (SslUtils.shortBE(byteBuffer, n4) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuffer, n4) & 0x3FFF) + 3;
                if (n3 <= n2) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n3;
    }

    static void handleHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl2) {
        channelHandlerContext.flush();
        if (bl2) {
            channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
        }
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!byteBuf.isReadOnly()) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), true, Base64Dialect.STANDARD, byteBufAllocator);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    private SslUtils() {
    }
}

