/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslExtendedKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$ExtendedTrustManagerVerifyCallback;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$OpenSslSniHostnameMatcher;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$ServerContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext$TrustManagerVerifyCallback;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SniHostNameMatcher;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;
    private final OpenSslKeyMaterialManager keyMaterialManager;

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3) {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, ReferenceCountedOpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l3, clientAuth, stringArray, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3) {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l2, l3, 1, (Certificate[])x509CertificateArray2, clientAuth, stringArray, bl2, bl3, true);
        boolean bl4 = false;
        try {
            ReferenceCountedOpenSslServerContext$ServerContext referenceCountedOpenSslServerContext$ServerContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory);
            this.sessionContext = referenceCountedOpenSslServerContext$ServerContext.sessionContext;
            this.keyMaterialManager = referenceCountedOpenSslServerContext$ServerContext.keyMaterialManager;
            bl4 = true;
        }
        finally {
            if (!bl4) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    OpenSslKeyMaterialManager keyMaterialManager() {
        return this.keyMaterialManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReferenceCountedOpenSslServerContext$ServerContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory) {
        Object object;
        ReferenceCountedOpenSslServerContext$ServerContext referenceCountedOpenSslServerContext$ServerContext = new ReferenceCountedOpenSslServerContext$ServerContext();
        try {
            SSLContext.setVerify((long)l2, (int)0, (int)10);
            if (!OpenSsl.useKeyManagerFactory()) {
                if (keyManagerFactory != null) {
                    throw new IllegalArgumentException("KeyManagerFactory not supported");
                }
                ObjectUtil.checkNotNull(x509CertificateArray2, "keyCertChain");
                ReferenceCountedOpenSslServerContext.setKeyMaterial(l2, x509CertificateArray2, privateKey, string);
            } else {
                if (keyManagerFactory == null) {
                    keyManagerFactory = ReferenceCountedOpenSslServerContext.buildKeyManagerFactory(x509CertificateArray2, privateKey, string, keyManagerFactory);
                }
                referenceCountedOpenSslServerContext$ServerContext.keyMaterialManager = ReferenceCountedOpenSslServerContext.useExtendedKeyManager((X509KeyManager)(object = ReferenceCountedOpenSslServerContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()))) ? new OpenSslExtendedKeyMaterialManager((X509ExtendedKeyManager)object, string) : new OpenSslKeyMaterialManager((X509KeyManager)object, string);
            }
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        try {
            if (x509CertificateArray != null) {
                trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory);
            } else if (trustManagerFactory == null) {
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
            }
            object = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
            if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager((X509TrustManager)object)) {
                SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ReferenceCountedOpenSslServerContext$ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)object));
            } else {
                SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ReferenceCountedOpenSslServerContext$TrustManagerVerifyCallback(openSslEngineMap, (X509TrustManager)object));
            }
            X509Certificate[] x509CertificateArray3 = object.getAcceptedIssuers();
            if (x509CertificateArray3 != null && x509CertificateArray3.length > 0) {
                long l3 = 0L;
                try {
                    l3 = ReferenceCountedOpenSslServerContext.toBIO(x509CertificateArray3);
                    if (!SSLContext.setCACertificateBio((long)l2, (long)l3)) {
                        throw new SSLException("unable to setup accepted issuers for trustmanager " + object);
                    }
                }
                finally {
                    ReferenceCountedOpenSslServerContext.freeBio(l3);
                }
            }
            if (PlatformDependent.javaVersion() >= 8) {
                SSLContext.setSniHostnameMatcher((long)l2, (SniHostNameMatcher)new ReferenceCountedOpenSslServerContext$OpenSslSniHostnameMatcher(openSslEngineMap));
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("unable to setup trustmanager", exception);
        }
        referenceCountedOpenSslServerContext$ServerContext.sessionContext = new OpenSslServerSessionContext(referenceCountedOpenSslContext);
        referenceCountedOpenSslServerContext$ServerContext.sessionContext.setSessionIdContext(ID);
        return referenceCountedOpenSslServerContext$ServerContext;
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

